/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ExpressionFactory;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;

class ExpressionFactoryCache {
    private final AtomicReference<WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>>> factoryCache = new AtomicReference(new WeakHashMap());

    ExpressionFactoryCache() {
    }

    ExpressionFactory getOrCreateExpressionFactory(ClassLoader classLoader) {
        WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>> weakHashMap;
        WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>> weakHashMap2;
        ExpressionFactory expressionFactory = null;
        do {
            WeakReference<ExpressionFactory> weakReference;
            if ((weakReference = (weakHashMap2 = this.factoryCache.get()).get(classLoader)) != null && (expressionFactory = (ExpressionFactory)weakReference.get()) != null) {
                return expressionFactory;
            }
            if (expressionFactory == null) {
                expressionFactory = ExpressionFactory.newInstance();
            }
            weakReference = new WeakReference<ExpressionFactory>(expressionFactory);
            weakHashMap = new WeakHashMap<ClassLoader, WeakReference<ExpressionFactory>>(weakHashMap2);
            weakHashMap.put(classLoader, weakReference);
        } while (!this.factoryCache.compareAndSet(weakHashMap2, weakHashMap));
        return expressionFactory;
    }
}

