/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.gtile;

import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.gtile.GAbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.gtile.GPoint;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.utils.Direction;

public class GConnectionHorizontalThenVerticalDown
extends GAbstractConnection {
    private final TextBlock textBlock;
    private final UTranslate pos1;
    private final UTranslate pos2;

    public GConnectionHorizontalThenVerticalDown(UTranslate pos1, GPoint gpoint1, UTranslate pos2, GPoint gpoint2, TextBlock textBlock) {
        super(gpoint1, gpoint2);
        this.textBlock = textBlock;
        this.pos1 = pos1;
        this.pos2 = pos2;
        if (pos1.getTranslated(gpoint1.getPoint2D()).getX() == pos2.getTranslated(gpoint2.getPoint2D()).getX()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
        Direction newDirection;
        XPoint2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        XPoint2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        Direction originalDirection = Direction.leftOrRight(p1, p2);
        if (originalDirection != (newDirection = Direction.leftOrRight(p1 = translate1.getTranslated(p1), p2 = translate2.getTranslated(p2)))) {
            double delta = (double)(originalDirection == Direction.RIGHT ? -1 : 1) * 12.0;
            XDimension2D dimDiamond1 = new XDimension2D(0.0, 0.0);
            Snake small = Snake.create(this.skinParam(), this.getInLinkRenderingColor()).withLabel(this.textBlock, HorizontalAlignment.LEFT);
            small.addPoint(p1);
            small.addPoint(p1.getX() + delta, p1.getY());
            small.addPoint(p1.getX() + delta, p1.getY() + dimDiamond1.getHeight() * 0.75);
            ug.draw(small);
            p1 = small.getLast();
        }
        UPolygon usingArrow = this.skinParam().arrows().asToDown();
        Snake snake = Snake.create(this.skinParam(), this.getInLinkRenderingColor(), usingArrow).withLabel(this.textBlock, HorizontalAlignment.LEFT).withMerge(MergeStrategy.LIMITED);
        snake.addPoint(p1);
        snake.addPoint(p2.getX(), p1.getY());
        snake.addPoint(p2);
        ug.draw(snake);
    }

    @Override
    public void drawU(UGraphic ug) {
        Snake snake = Snake.create(this.skinParam(), this.getInLinkRenderingColor(), this.skinParam().arrows().asToDown()).withLabel(this.textBlock, HorizontalAlignment.LEFT);
        XPoint2D p1 = this.pos1.getTranslated(this.gpoint1.getPoint2D());
        XPoint2D p2 = this.pos2.getTranslated(this.gpoint2.getPoint2D());
        snake.addPoint(p1);
        snake.addPoint(new XPoint2D(p2.getX(), p1.getY()));
        snake.addPoint(p2);
        ug.draw(snake);
    }
}

