/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.analysis.ja.Token;
import org.apache.lucene.analysis.ja.dict.CharacterDefinition;
import org.apache.lucene.analysis.ja.dict.JaMorphData;
import org.apache.lucene.analysis.ja.dict.TokenInfoDictionary;
import org.apache.lucene.analysis.ja.dict.UnknownDictionary;
import org.apache.lucene.analysis.ja.dict.UserDictionary;
import org.apache.lucene.analysis.morph.BinaryDictionary;
import org.apache.lucene.analysis.morph.ConnectionCosts;
import org.apache.lucene.analysis.morph.Dictionary;
import org.apache.lucene.analysis.morph.GraphvizFormatter;
import org.apache.lucene.analysis.morph.TokenInfoFST;
import org.apache.lucene.analysis.morph.TokenType;
import org.apache.lucene.analysis.morph.Viterbi;
import org.apache.lucene.analysis.morph.ViterbiNBest;
import org.apache.lucene.util.fst.FST;

final class ViterbiNBest
extends org.apache.lucene.analysis.morph.ViterbiNBest<Token, JaMorphData> {
    private final UnknownDictionary unkDictionary;
    private final CharacterDefinition characterDefinition;
    private final UserDictionary userDictionary;
    private final boolean discardPunctuation;
    private final boolean searchMode;
    private final boolean extendedMode;
    private final boolean outputCompounds;
    private GraphvizFormatter<JaMorphData> dotOut;
    private static final int SEARCH_MODE_KANJI_LENGTH = 2;
    private static final int SEARCH_MODE_OTHER_LENGTH = 7;
    private static final int SEARCH_MODE_KANJI_PENALTY = 3000;
    private static final int SEARCH_MODE_OTHER_PENALTY = 1700;

    ViterbiNBest(TokenInfoFST fst, FST.BytesReader fstReader, TokenInfoDictionary dictionary, TokenInfoFST userFST, FST.BytesReader userFSTReader, UserDictionary userDictionary, ConnectionCosts costs, UnknownDictionary unkDictionary, CharacterDefinition characterDefinition, boolean discardPunctuation, boolean searchMode, boolean extendedMode, boolean outputCompounds) {
        super(fst, fstReader, (BinaryDictionary)dictionary, userFST, userFSTReader, (Dictionary)userDictionary, costs);
        this.unkDictionary = unkDictionary;
        this.characterDefinition = characterDefinition;
        this.userDictionary = userDictionary;
        this.discardPunctuation = discardPunctuation;
        this.searchMode = searchMode;
        this.extendedMode = extendedMode;
        this.outputCompounds = outputCompounds;
        this.dictionaryMap.put(TokenType.KNOWN, dictionary);
        this.dictionaryMap.put(TokenType.UNKNOWN, unkDictionary);
        this.dictionaryMap.put(TokenType.USER, userDictionary);
    }

    protected boolean shouldSkipProcessUnknownWord(int unknownWordEndIndex, Viterbi.Position posData) {
        return !this.searchMode && super.shouldSkipProcessUnknownWord(unknownWordEndIndex, posData);
    }

    protected int computePenalty(int pos, int length) throws IOException {
        if (length > 2) {
            boolean allKanji = true;
            int endPos = pos + length;
            for (int pos2 = pos; pos2 < endPos; ++pos2) {
                if (this.characterDefinition.isKanji((char)this.buffer.get(pos2))) continue;
                allKanji = false;
                break;
            }
            if (allKanji) {
                return (length - 2) * 3000;
            }
            if (length > 7) {
                return (length - 7) * 1700;
            }
        }
        return 0;
    }

    private int computeSecondBestThreshold(int pos, int length) throws IOException {
        return this.computePenalty(pos, length);
    }

    protected int processUnknownWord(boolean anyMatches, Viterbi.Position posData) throws IOException {
        char firstCharacter = (char)this.buffer.get(this.pos);
        if (!anyMatches || this.characterDefinition.isInvoke(firstCharacter)) {
            int unknownWordLength;
            byte characterId = this.characterDefinition.getCharacterClass(firstCharacter);
            boolean isPunct = ViterbiNBest.isPunctuation(firstCharacter);
            if (!this.characterDefinition.isGroup(firstCharacter)) {
                unknownWordLength = 1;
            } else {
                int ch;
                unknownWordLength = 1;
                int posAhead = this.pos + 1;
                while (unknownWordLength < 1024 && (ch = this.buffer.get(posAhead)) != -1 && characterId == this.characterDefinition.getCharacterClass((char)ch) && ViterbiNBest.isPunctuation((char)ch) == isPunct) {
                    ++unknownWordLength;
                    ++posAhead;
                }
            }
            this.unkDictionary.lookupWordIds(characterId, this.wordIdRef);
            for (int ofs = 0; ofs < this.wordIdRef.length; ++ofs) {
                this.add(this.unkDictionary.getMorphAttributes(), posData, this.pos, posData.getPos() + unknownWordLength, this.wordIdRef.ints[this.wordIdRef.offset + ofs], TokenType.UNKNOWN, false);
            }
            return unknownWordLength;
        }
        return 0;
    }

    void setGraphvizFormatter(GraphvizFormatter<JaMorphData> dotOut) {
        this.dotOut = dotOut;
    }

    protected void backtrace(Viterbi.Position endPosData, int fromIDX) throws IOException {
        int endPos = endPosData.getPos();
        if (endPos == this.lastBackTracePos) {
            return;
        }
        char[] fragment = this.buffer.get(this.lastBackTracePos, endPos - this.lastBackTracePos);
        if (this.dotOut != null) {
            this.dotOut.onBacktrace(this::getDict, this.positions, this.lastBackTracePos, endPosData, fromIDX, fragment, this.end);
        }
        int pos = endPos;
        int bestIDX = fromIDX;
        Token altToken = null;
        int lastLeftWordID = -1;
        int backCount = 0;
        while (pos > this.lastBackTracePos) {
            int penalty;
            Viterbi.Position posData = this.positions.get(pos);
            assert (bestIDX < posData.getCount());
            int backPos = posData.getBackPos(bestIDX);
            assert (backPos >= this.lastBackTracePos) : "backPos=" + backPos + " vs lastBackTracePos=" + this.lastBackTracePos;
            int length = pos - backPos;
            TokenType backType = posData.getBackType(bestIDX);
            int backID = posData.getBackID(bestIDX);
            int nextBestIDX = posData.getBackIndex(bestIDX);
            if (this.searchMode && altToken == null && backType != TokenType.USER && (penalty = this.computeSecondBestThreshold(backPos, pos - backPos)) > 0) {
                int maxCost = posData.getCost(bestIDX) + penalty;
                if (lastLeftWordID != -1) {
                    maxCost += this.costs.get(this.getDict(backType).getRightId(backID), lastLeftWordID);
                }
                this.pruneAndRescore(backPos, pos, posData.getBackIndex(bestIDX));
                int leastCost = Integer.MAX_VALUE;
                int leastIDX = -1;
                for (int idx = 0; idx < posData.getCount(); ++idx) {
                    int cost = posData.getCost(idx);
                    if (lastLeftWordID != -1) {
                        cost += this.costs.get(this.getDict(posData.getBackType(idx)).getRightId(posData.getBackID(idx)), lastLeftWordID);
                    }
                    if (cost >= leastCost) continue;
                    leastCost = cost;
                    leastIDX = idx;
                }
                if (leastIDX != -1 && leastCost <= maxCost && posData.getBackPos(leastIDX) != backPos) {
                    assert (posData.getBackPos(leastIDX) != backPos);
                    altToken = new Token(fragment, backPos - this.lastBackTracePos, length, backPos, backPos + length, backID, backType, (JaMorphData)this.getDict(backType).getMorphAttributes());
                    bestIDX = leastIDX;
                    nextBestIDX = posData.getBackIndex(bestIDX);
                    backPos = posData.getBackPos(bestIDX);
                    length = pos - backPos;
                    backType = posData.getBackType(bestIDX);
                    backID = posData.getBackID(bestIDX);
                    backCount = 0;
                }
            }
            int offset = backPos - this.lastBackTracePos;
            assert (offset >= 0);
            if (altToken != null && altToken.getStartOffset() >= backPos) {
                if (this.outputCompounds) {
                    assert (altToken.getStartOffset() == backPos) : altToken.getStartOffset() + " vs " + backPos;
                    if (backCount > 0) {
                        altToken.setPositionLength(++backCount);
                        this.pending.add(altToken);
                    } else assert (this.discardPunctuation);
                }
                altToken = null;
            }
            Dictionary<? extends JaMorphData> dict = this.getDict(backType);
            if (backType == TokenType.USER) {
                int[] wordIDAndLength = this.userDictionary.lookupSegmentation(backID);
                int wordID = wordIDAndLength[0];
                int current = 0;
                for (int j = 1; j < wordIDAndLength.length; ++j) {
                    int len = wordIDAndLength[j];
                    int startOffset = current + backPos;
                    this.pending.add(new Token(fragment, current + offset, len, startOffset, startOffset + len, wordID + j - 1, TokenType.USER, (JaMorphData)dict.getMorphAttributes()));
                    current += len;
                }
                Collections.reverse(this.pending.subList(this.pending.size() - (wordIDAndLength.length - 1), this.pending.size()));
                backCount += wordIDAndLength.length - 1;
            } else if (this.extendedMode && backType == TokenType.UNKNOWN) {
                int unigramTokenCount = 0;
                for (int i = length - 1; i >= 0; --i) {
                    int charLen = 1;
                    if (i > 0 && Character.isLowSurrogate(fragment[offset + i])) {
                        --i;
                        charLen = 2;
                    }
                    if (this.discardPunctuation && ViterbiNBest.isPunctuation(fragment[offset + i])) continue;
                    int startOffset = backPos + i;
                    this.pending.add(new Token(fragment, offset + i, charLen, startOffset, startOffset + charLen, CharacterDefinition.NGRAM, TokenType.UNKNOWN, this.unkDictionary.getMorphAttributes()));
                    ++unigramTokenCount;
                }
                backCount += unigramTokenCount;
            } else if (!this.discardPunctuation || length == 0 || !ViterbiNBest.isPunctuation(fragment[offset])) {
                this.pending.add(new Token(fragment, offset, length, backPos, backPos + length, backID, backType, (JaMorphData)dict.getMorphAttributes()));
                ++backCount;
            }
            lastLeftWordID = dict.getLeftId(backID);
            pos = backPos;
            bestIDX = nextBestIDX;
        }
        this.lastBackTracePos = endPos;
        this.buffer.freeBefore(endPos);
        this.positions.freeBefore(endPos);
    }

    private void pruneAndRescore(int startPos, int endPos, int bestStartIDX) throws IOException {
        Viterbi.Position posData;
        int pos;
        for (pos = endPos; pos > startPos; --pos) {
            posData = this.positions.get(pos);
            for (int arcIDX = 0; arcIDX < posData.getCount(); ++arcIDX) {
                int backPos = posData.getBackPos(arcIDX);
                if (backPos < startPos) continue;
                ((ViterbiNBest.PositionNBest)this.positions.get(backPos)).addForward(pos, arcIDX, posData.getBackID(arcIDX), posData.getBackType(arcIDX));
            }
            if (pos == startPos) continue;
            posData.setCount(0);
        }
        for (pos = startPos; pos < endPos; ++pos) {
            posData = (ViterbiNBest.PositionNBest)this.positions.get(pos);
            if (posData.getCount() == 0) {
                posData.setForwardCount(0);
                continue;
            }
            if (pos == startPos) {
                int rightID = startPos == 0 ? 0 : this.getDict(posData.getBackType(bestStartIDX)).getRightId(posData.getBackID(bestStartIDX));
                int pathCost = posData.getCost(bestStartIDX);
                for (int forwardArcIDX = 0; forwardArcIDX < posData.getForwardCount(); ++forwardArcIDX) {
                    TokenType forwardType = posData.getForwardType(forwardArcIDX);
                    Dictionary<? extends JaMorphData> dict2 = this.getDict(forwardType);
                    int wordID = posData.getForwardID(forwardArcIDX);
                    int toPos = posData.getForwardPos(forwardArcIDX);
                    int newCost = pathCost + dict2.getWordCost(wordID) + this.costs.get(rightID, dict2.getLeftId(wordID)) + this.computePenalty(pos, toPos - pos);
                    ((ViterbiNBest.PositionNBest)this.positions.get(toPos)).add(newCost, dict2.getRightId(wordID), pos, -1, bestStartIDX, wordID, forwardType);
                }
            } else {
                for (int forwardArcIDX = 0; forwardArcIDX < posData.getForwardCount(); ++forwardArcIDX) {
                    TokenType forwardType = posData.getForwardType(forwardArcIDX);
                    int toPos = posData.getForwardPos(forwardArcIDX);
                    this.add(this.getDict(forwardType).getMorphAttributes(), posData, pos, toPos, posData.getForwardID(forwardArcIDX), forwardType, true);
                }
            }
            posData.setForwardCount(0);
        }
    }

    protected void registerNode(int node, char[] fragment) {
        int left = this.lattice.getNodeLeft(node);
        int right = this.lattice.getNodeRight(node);
        TokenType type = this.lattice.getNodeDicType(node);
        if (!this.discardPunctuation || !ViterbiNBest.isPunctuation(fragment[left])) {
            if (type == TokenType.USER) {
                int[] wordIDAndLength = this.userDictionary.lookupSegmentation(this.lattice.getNodeWordID(node));
                int wordID = wordIDAndLength[0];
                this.pending.add(new Token(fragment, left, right - left, this.lattice.getRootBase() + left, this.lattice.getRootBase() + right, wordID, TokenType.USER, this.userDictionary.getMorphAttributes()));
                int current = 0;
                for (int j = 1; j < wordIDAndLength.length; ++j) {
                    int len = wordIDAndLength[j];
                    if (len < right - left) {
                        int startOffset = this.lattice.getRootBase() + current + left;
                        this.pending.add(new Token(fragment, current + left, len, startOffset, startOffset + len, wordID + j - 1, TokenType.USER, this.userDictionary.getMorphAttributes()));
                    }
                    current += len;
                }
            } else {
                this.pending.add(new Token(fragment, left, right - left, this.lattice.getRootBase() + left, this.lattice.getRootBase() + right, this.lattice.getNodeWordID(node), type, (JaMorphData)this.getDict(type).getMorphAttributes()));
            }
        }
    }

    Dictionary<? extends JaMorphData> getDict(TokenType type) {
        return (Dictionary)this.dictionaryMap.get(type);
    }

    protected void setNBestCost(int value) {
        super.setNBestCost(value);
    }

    protected int getNBestCost() {
        return super.getNBestCost();
    }

    private static boolean isPunctuation(char ch) {
        switch (Character.getType(ch)) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

