/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.util.Map;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.StatefulSearchRequestProcessor;
import org.opensearch.search.pipeline.common.helpers.ContextUtils;

public class OversampleRequestProcessor
extends AbstractProcessor
implements StatefulSearchRequestProcessor {
    public static final String TYPE = "oversample";
    static final String SAMPLE_FACTOR = "sample_factor";
    static final String ORIGINAL_SIZE = "original_size";
    private final double sampleFactor;
    private final String contextPrefix;

    private OversampleRequestProcessor(String tag, String description, boolean ignoreFailure, double sampleFactor, String contextPrefix) {
        super(tag, description, ignoreFailure);
        this.sampleFactor = sampleFactor;
        this.contextPrefix = contextPrefix;
    }

    public SearchRequest processRequest(SearchRequest request, PipelineProcessingContext requestContext) {
        if (request.source() != null) {
            int originalSize = request.source().size();
            if (originalSize == -1) {
                originalSize = 10;
            }
            requestContext.setAttribute(ContextUtils.applyContextPrefix(this.contextPrefix, ORIGINAL_SIZE), (Object)originalSize);
            int newSize = (int)Math.ceil((double)originalSize * this.sampleFactor);
            request.source().size(newSize);
        }
        return request;
    }

    public String getType() {
        return TYPE;
    }

    static class Factory
    implements Processor.Factory<SearchRequestProcessor> {
        Factory() {
        }

        public OversampleRequestProcessor create(Map<String, Processor.Factory<SearchRequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
            double sampleFactor = ConfigurationUtils.readDoubleProperty((String)OversampleRequestProcessor.TYPE, (String)tag, config, (String)OversampleRequestProcessor.SAMPLE_FACTOR);
            if (sampleFactor < 1.0) {
                throw ConfigurationUtils.newConfigurationException((String)OversampleRequestProcessor.TYPE, (String)tag, (String)OversampleRequestProcessor.SAMPLE_FACTOR, (String)"Value must be >= 1.0");
            }
            String contextPrefix = ConfigurationUtils.readOptionalStringProperty((String)OversampleRequestProcessor.TYPE, (String)tag, config, (String)"context_prefix");
            return new OversampleRequestProcessor(tag, description, ignoreFailure, sampleFactor, contextPrefix);
        }
    }
}

