/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFDCNConnectionGroup;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFJMSConnectionGroup;
import oracle.jdbc.driver.NTFListener;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

class NTFManager
implements Monitor,
Diagnosable {
    private static final String CLASS_NAME = NTFManager.class.getName();
    private Hashtable<Integer, NTFListener> nsListeners = new Hashtable();
    private Hashtable<Integer, NTFRegistration> ntfRegistrations = new Hashtable();
    private ConcurrentHashMap<Long, NTFDCNRegistration> dcnRegistrations = new ConcurrentHashMap();
    private byte[] listOfJdbcRegId = new byte[20];
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId = new HashMap();
    private HashMap<String, NTFJMSConnectionGroup> jmsConnectionGroups = new HashMap();
    private HashMap<String, NTFDCNConnectionGroup> dcnConnectionGroups = new HashMap();
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    NTFManager() {
    }

    boolean listenOnPortT4C(int[] portArr, boolean force, @Blind(value=PropertiesBlinder.class) Properties socketOptions, Exception[] connectionCreationExceptionArr) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int tryPort = portArr[0];
            boolean newListenerThreadCreated = false;
            while (true) {
                NTFListener listener;
                if ((listener = this.nsListeners.get(tryPort)) != null) {
                    if (connectionCreationExceptionArr != null && connectionCreationExceptionArr.length > 0) {
                        Exception ioe;
                        connectionCreationExceptionArr[0] = ioe = listener.getRegistrationException();
                    }
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "listenOnPortT4C", "tcpport={0}. Already listening. ", (String)null, (Throwable)null, (Object)tryPort);
                    break;
                }
                try {
                    ServerSocketChannel ssChannel = ServerSocketChannel.open();
                    ssChannel.configureBlocking(false);
                    ServerSocket serverSocket = ssChannel.socket();
                    InetSocketAddress isa = new InetSocketAddress(tryPort);
                    try {
                        serverSocket.bind(isa);
                        newListenerThreadCreated = true;
                        listener = new NTFListener(this, ssChannel, tryPort, socketOptions, connectionCreationExceptionArr);
                        this.nsListeners.put(tryPort, listener);
                        listener.start();
                        PropertiesBlinder propertiesBlinder = new PropertiesBlinder();
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "listenOnPortT4C", "Started listener. tcpport={0}, socketOptions={1}. ", (String)null, (Throwable)null, (Object)tryPort, (Object)propertiesBlinder.blind(socketOptions));
                        break;
                    }
                    catch (BindException be) {
                        if (!force) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 250).fillInStackTrace();
                        }
                        serverSocket.close();
                        ++tryPort;
                    }
                    catch (IOException iox2) {
                        if (!force) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 250).fillInStackTrace();
                        }
                        serverSocket.close();
                        ++tryPort;
                    }
                }
                catch (IOException ioe) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
                }
            }
            portArr[0] = tryPort;
            boolean bl = newListenerThreadCreated;
            return bl;
        }
    }

    int getNextJdbcRegId() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int off;
            for (off = 1; off < this.listOfJdbcRegId.length && this.listOfJdbcRegId[off] != 0; ++off) {
            }
            if (off == this.listOfJdbcRegId.length - 1) {
                byte[] listOfJdbcRegId2 = new byte[this.listOfJdbcRegId.length * 2];
                System.arraycopy(this.listOfJdbcRegId, 0, listOfJdbcRegId2, 0, this.listOfJdbcRegId.length);
                this.listOfJdbcRegId = listOfJdbcRegId2;
            }
            this.listOfJdbcRegId[off] = 2;
            int n = off;
            return n;
        }
    }

    void addRegistration(NTFRegistration registration) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Integer key = registration.getJdbcRegId();
            Hashtable ntfRegistrations2 = (Hashtable)this.ntfRegistrations.clone();
            ntfRegistrations2.put(key, registration);
            this.ntfRegistrations = ntfRegistrations2;
        }
    }

    boolean removeRegistration(NTFRegistration registration) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Integer key = registration.getJdbcRegId();
            Hashtable ntfRegistrations2 = (Hashtable)this.ntfRegistrations.clone();
            Object obj = ntfRegistrations2.remove(key);
            this.ntfRegistrations = ntfRegistrations2;
            boolean ret = false;
            if (obj != null) {
                ret = true;
            }
            boolean bl = ret;
            return bl;
        }
    }

    void freeJdbcRegId(int jdbcRegId) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.listOfJdbcRegId != null && this.listOfJdbcRegId.length > jdbcRegId) {
                this.listOfJdbcRegId[jdbcRegId] = 0;
            }
        }
    }

    void cleanListenersT4C(int tcpport) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NTFListener listener;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanListenersT4C", "tcpport={0}. Cleaning listener.", (String)null, (Throwable)null, (Object)tcpport);
            Enumeration<Integer> keys = this.ntfRegistrations.keys();
            boolean portUsed = false;
            while (!portUsed && keys.hasMoreElements()) {
                Integer localkey = keys.nextElement();
                NTFRegistration reg = this.ntfRegistrations.get(localkey);
                if (reg.getClientTCPPort() != tcpport) continue;
                portUsed = true;
            }
            if (!portUsed && (listener = this.nsListeners.get(tcpport)) != null) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanListenersT4C", "tcpport={0}. Closing listener. ", (String)null, (Throwable)null, (Object)tcpport);
                listener.closeThisListener();
                listener.interrupt();
                this.nsListeners.remove(tcpport);
            }
        }
    }

    NTFRegistration getRegistration(int jdbcRegId) {
        Integer key = jdbcRegId;
        Hashtable<Integer, NTFRegistration> localHandle = this.ntfRegistrations;
        NTFRegistration obj = localHandle.get(key);
        return obj;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    void removeJMSRegistrationId(Long jmsRegistrationId) {
        this.jmsRegIdToJDBCRegId.remove(jmsRegistrationId);
    }

    int getJDBCRegId(Long jmsRegistrationId) {
        return this.jmsRegIdToJDBCRegId.get(jmsRegistrationId);
    }

    void mapJMSRegIdToJDBCRegId(Long jmsRegistrationId, int jdbcRegistrationId) {
        this.jmsRegIdToJDBCRegId.put(jmsRegistrationId, jdbcRegistrationId);
    }

    NTFJMSConnectionGroup getJMSConnectionGroup(String key) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NTFJMSConnectionGroup newObject = this.jmsConnectionGroups.get(key);
            if (newObject == null) {
                newObject = new NTFJMSConnectionGroup(key);
            }
            this.jmsConnectionGroups.put(key, newObject);
            NTFJMSConnectionGroup nTFJMSConnectionGroup = newObject;
            return nTFJMSConnectionGroup;
        }
    }

    void removeJMSConnectionGroup(String key) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.jmsConnectionGroups.remove(key);
        }
    }

    NTFDCNConnectionGroup getDCNConnectionGroup(String key) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            NTFDCNConnectionGroup newObject = this.dcnConnectionGroups.get(key);
            if (newObject == null) {
                newObject = new NTFDCNConnectionGroup(key);
            }
            this.dcnConnectionGroups.put(key, newObject);
            NTFDCNConnectionGroup nTFDCNConnectionGroup = newObject;
            return nTFDCNConnectionGroup;
        }
    }

    void removeDCNConnectionGroup(String key) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.dcnConnectionGroups.remove(key);
        }
    }

    void addDCNRegistration(NTFDCNRegistration registration) {
        this.dcnRegistrations.put(registration.getRegId(), registration);
    }

    NTFDCNRegistration getDCNRegistration(long regId) {
        return this.dcnRegistrations.get(regId);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

