/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.keycloak.quarkus.runtime.Environment;

public final class QuarkusPropertiesConfigSource
extends AbstractLocationConfigSourceLoader
implements ConfigSourceProvider {
    private static final String FILE_NAME = "quarkus.properties";
    public static final String NAME = "KcQuarkusPropertiesConfigSource";

    public static Path getConfigurationFile() {
        File file;
        String homeDir = Environment.getHomeDir();
        if (homeDir != null && (file = Paths.get(homeDir, "conf", FILE_NAME).toFile()).exists()) {
            return file.toPath();
        }
        return null;
    }

    protected String[] getFileExtensions() {
        return new String[]{"properties"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        Map map = ConfigSourceUtil.urlToMap((URL)url);
        map.keySet().removeIf(k -> !k.startsWith("quarkus"));
        return new PropertiesConfigSource(map, NAME, ordinal);
    }

    public synchronized List<ConfigSource> getConfigSources(ClassLoader classLoader) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        Path configFile = QuarkusPropertiesConfigSource.getConfigurationFile();
        if (configFile != null) {
            configSources.addAll(this.loadConfigSources(configFile.toUri().toString(), 475, classLoader));
        }
        return configSources;
    }
}

