/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.client.challenge;

import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultChallenge
implements Challenge {
    private final byte[] value;

    public DefaultChallenge(@NotNull byte[] value) {
        AssertUtil.notNull(value, "value cannot be null");
        this.value = value;
    }

    public DefaultChallenge(@NotNull String base64urlString) {
        AssertUtil.notNull(base64urlString, "base64urlString cannot be null");
        this.value = Base64UrlUtil.decode(base64urlString);
    }

    public DefaultChallenge() {
        UUID uuid = UUID.randomUUID();
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        this.value = ByteBuffer.allocate(16).putLong(hi).putLong(lo).array();
    }

    @Override
    @NotNull
    public byte[] getValue() {
        return ArrayUtil.clone(this.value);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultChallenge that = (DefaultChallenge)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return ArrayUtil.toHexString(this.value);
    }
}

