/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class FromClauseAccessImpl
implements FromClauseAccess {
    private Map<String, TableGroup> tableGroupBySqlAlias;
    private Map<NavigablePath, TableGroup> tableGroupByPath;

    public TableGroup getByAlias(String alias) {
        TableGroup byAlias = this.findByAlias(alias);
        if (byAlias == null) {
            throw new IllegalArgumentException("Could not resolve TableGroup by alias [" + alias + "]");
        }
        return byAlias;
    }

    public TableGroup findByAlias(String alias) {
        if (this.tableGroupBySqlAlias != null) {
            return this.tableGroupBySqlAlias.get(alias);
        }
        return null;
    }

    @Override
    public @Nullable TableGroup findTableGroupByIdentificationVariable(String identificationVariable) {
        for (TableGroup tableGroup : this.tableGroupByPath.values()) {
            if (tableGroup.findTableReference(identificationVariable) == null) continue;
            return tableGroup;
        }
        return null;
    }

    @Override
    public TableGroup findTableGroupOnCurrentFromClause(NavigablePath navigablePath) {
        return null;
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        if (this.tableGroupByPath != null) {
            return this.tableGroupByPath.get(navigablePath);
        }
        return null;
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        if (this.tableGroupByPath == null) {
            this.tableGroupByPath = new HashMap<NavigablePath, TableGroup>();
        }
        this.tableGroupByPath.put(navigablePath, tableGroup);
        if (tableGroup.getGroupAlias() != null) {
            if (this.tableGroupBySqlAlias == null) {
                this.tableGroupBySqlAlias = new HashMap<String, TableGroup>();
            }
            this.tableGroupBySqlAlias.put(tableGroup.getGroupAlias(), tableGroup);
        }
    }
}

