/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.EventSetImpl;
import com.jetbrains.jdi.MirrorImpl;
import com.jetbrains.jdi.TargetVM;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import java.util.LinkedList;

public class EventQueueImpl
extends MirrorImpl
implements EventQueue {
    final LinkedList<EventSet> eventSets = new LinkedList();
    final TargetVM target;
    boolean closed = false;

    EventQueueImpl(VirtualMachine vm, TargetVM target) {
        super(vm);
        this.target = target;
        target.addEventQueue(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    synchronized void enqueue(EventSet eventSet) {
        this.eventSets.add(eventSet);
        this.notifyAll();
    }

    synchronized int size() {
        return this.eventSets.size();
    }

    synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.enqueue(new EventSetImpl((VirtualMachine)this.vm, 100));
        }
    }

    @Override
    public EventSet remove() throws InterruptedException {
        return this.remove(0L);
    }

    @Override
    public EventSet remove(long timeout2) throws InterruptedException {
        EventSetImpl fullEventSet;
        EventSet eventSet;
        if (timeout2 < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        do {
            if ((fullEventSet = this.removeUnfiltered(timeout2)) != null) continue;
            eventSet = null;
            break;
        } while ((eventSet = fullEventSet.userFilter()).isEmpty());
        if (eventSet != null && eventSet.suspendPolicy() == 2) {
            this.vm.notifySuspend();
        }
        return eventSet;
    }

    EventSet removeInternal() throws InterruptedException {
        EventSet eventSet;
        while ((eventSet = this.removeUnfiltered(0L).internalFilter()) == null || eventSet.isEmpty()) {
        }
        return eventSet;
    }

    private TimerThread startTimerThread(long timeout2) {
        TimerThread thread = new TimerThread(timeout2);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private boolean shouldWait(TimerThread timerThread) {
        return !this.closed && this.eventSets.isEmpty() && (timerThread == null || !timerThread.timedOut());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventSetImpl removeUnfiltered(long timeout2) throws InterruptedException {
        EventSetImpl eventSet = null;
        this.vm.waitInitCompletion();
        EventQueueImpl eventQueueImpl = this;
        synchronized (eventQueueImpl) {
            if (!this.eventSets.isEmpty()) {
                eventSet = (EventSetImpl)this.eventSets.removeFirst();
            } else {
                TimerThread timerThread = null;
                try {
                    if (timeout2 > 0L) {
                        timerThread = this.startTimerThread(timeout2);
                    }
                    while (this.shouldWait(timerThread)) {
                        this.wait();
                    }
                }
                finally {
                    if (timerThread != null && !timerThread.timedOut()) {
                        timerThread.interrupt();
                    }
                }
                if (this.eventSets.isEmpty()) {
                    if (this.closed) {
                        throw new VMDisconnectedException();
                    }
                } else {
                    eventSet = (EventSetImpl)this.eventSets.removeFirst();
                }
            }
        }
        if (eventSet != null) {
            this.target.notifyDequeueEventSet();
            eventSet.build();
        }
        return eventSet;
    }

    private class TimerThread
    extends Thread {
        private boolean timedOut;
        private final long timeout;

        TimerThread(long timeout2) {
            super(EventQueueImpl.this.vm.threadGroupForJDI(), "JDI Event Queue Timer");
            this.timedOut = false;
            this.timeout = timeout2;
        }

        boolean timedOut() {
            return this.timedOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                EventQueueImpl queue;
                Thread.sleep(this.timeout);
                EventQueueImpl eventQueueImpl = queue = EventQueueImpl.this;
                synchronized (eventQueueImpl) {
                    this.timedOut = true;
                    queue.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

