/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public abstract class GrCreateFromUsageBaseFix
extends Intention {
    @FileModifier.SafeFieldForPreview
    protected final SmartPsiElementPointer<GrReferenceExpression> myRefExpression;

    protected GrCreateFromUsageBaseFix(@NotNull GrReferenceExpression refExpression) {
        if (refExpression == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(0);
        }
        this.myRefExpression = SmartPointerManager.getInstance((Project)refExpression.getProject()).createSmartPsiElementPointer((PsiElement)refExpression);
    }

    protected GrReferenceExpression getRefExpr() {
        return (GrReferenceExpression)this.myRefExpression.getElement();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        GrReferenceExpression element;
        if (project == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(1);
        }
        if ((element = (GrReferenceExpression)this.myRefExpression.getElement()) == null || !element.isValid()) {
            return false;
        }
        List<PsiClass> targetClasses = this.getTargetClasses();
        return !targetClasses.isEmpty();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        List<PsiClass> classes;
        if (element == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GrCreateFromUsageBaseFix.$$$reportNull$$$0(3);
        }
        if ((classes = this.getTargetClasses()).size() == 1) {
            this.invokeImpl(project, classes.get(0));
        } else if (!classes.isEmpty()) {
            this.chooseClass(classes, editor);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element instanceof GrReferenceExpression;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix$1", "satisfiedBy"));
            }
        };
    }

    private void chooseClass(List<PsiClass> classes, Editor editor) {
        Project project = classes.get(0).getProject();
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(classes).setRenderer((ListCellRenderer)renderer).setSelectionMode(0).setItemChosenCallback(aClass -> CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> this.invokeImpl(project, (PsiClass)aClass)), this.getText(), null)).setTitle(QuickFixBundle.message((String)"target.class.chooser.title", (Object[])new Object[0]));
        renderer.installSpeedSearch(builder);
        builder.createPopup().showInBestPositionFor(editor);
    }

    protected abstract void invokeImpl(Project var1, @NotNull PsiClass var2);

    protected List<PsiClass> getTargetClasses() {
        GrReferenceExpression ref2 = this.getRefExpr();
        PsiClass targetClass = QuickfixUtil.findTargetClass(ref2);
        if (targetClass == null || !this.canBeTargetClass(targetClass)) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        this.collectSupers(targetClass, classes);
        return classes;
    }

    private void collectSupers(PsiClass psiClass, ArrayList<PsiClass> classes) {
        PsiClass[] supers;
        classes.add(psiClass);
        for (PsiClass aSuper : supers = psiClass.getSupers()) {
            if (classes.contains(aSuper) || !this.canBeTargetClass(aSuper)) continue;
            this.collectSupers(aSuper, classes);
        }
    }

    protected boolean canBeTargetClass(PsiClass psiClass) {
        return psiClass.getManager().isInProject((PsiElement)psiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFromUsageBaseFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

