/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import com.google.common.collect.Sets;
import java.util.Set;
import org.jspecify.annotations.NullMarked;

@NullMarked
public enum JavaInstallationCapability {
    JAVA_COMPILER,
    JAVADOC_TOOL,
    JAR_TOOL,
    J9_VIRTUAL_MACHINE,
    NATIVE_IMAGE;

    public static final Set<JavaInstallationCapability> JDK_CAPABILITIES;

    public final String toDisplayName() {
        switch (this) {
            case JAVA_COMPILER: {
                return "executable 'javac'";
            }
            case JAVADOC_TOOL: {
                return "executable 'javadoc'";
            }
            case JAR_TOOL: {
                return "executable 'jar'";
            }
            case J9_VIRTUAL_MACHINE: {
                return "J9 virtual machine";
            }
            case NATIVE_IMAGE: {
                return "executable 'native-image'";
            }
        }
        throw new IllegalStateException("Unknown capability: " + (Object)((Object)this));
    }

    static {
        JDK_CAPABILITIES = Sets.immutableEnumSet((Enum)JAVA_COMPILER, (Enum[])new JavaInstallationCapability[]{JAVADOC_TOOL, JAR_TOOL});
    }
}

