/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.opentelemetry.api.trace;

import org.jetbrains.kotlin.io.opentelemetry.api.trace.Span;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.SpanBuilder;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.SpanContext;
import org.jetbrains.kotlin.io.opentelemetry.api.trace.Tracer;

final class DefaultTracer
implements Tracer {
    private static final Tracer INSTANCE = new DefaultTracer();

    static Tracer getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        return NoopSpanBuilder.create();
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    implements SpanBuilder {
        private SpanContext spanContext;

        static NoopSpanBuilder create() {
            return new NoopSpanBuilder();
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = Span.current().getSpanContext();
            }
            return Span.wrap(this.spanContext);
        }

        private NoopSpanBuilder() {
        }
    }
}

