/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.feature.vt.api.main.VTAssociationMarkupStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class VTMarkupStatusIcon
implements Icon {
    private static final Color BG_APPLIED = new GColor("color.bg.version.tracking.match.table.markup.status.applied");
    private static final Color BG_REJECTED = new GColor("color.bg.version.tracking.match.table.markup.status.rejected");
    private static final Color BG_DONT_CARE = new GColor("color.bg.version.tracking.match.table.markup.status.dont.care");
    private static final Color BG_DONT_KNOW = new GColor("color.bg.version.tracking.match.table.markup.status.dont.know");
    private int BORDER = 2;
    private int WIDTH = 44;
    private int KNOB_WIDTH = 4;
    private int HEIGHT = 16;
    private VTAssociationMarkupStatus status = new VTAssociationMarkupStatus(255);

    @Override
    public int getIconHeight() {
        return this.HEIGHT;
    }

    @Override
    public int getIconWidth() {
        return this.WIDTH + this.KNOB_WIDTH;
    }

    void setStatus(VTAssociationMarkupStatus status) {
        this.status = status;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        double size;
        List<Color> colors = this.getColors(this.status);
        int numColors = colors.size();
        double d = size = numColors == 0 ? 0.0 : ((double)this.WIDTH - (double)(2 * this.BORDER) - 1.0) / (double)numColors;
        if (this.status.hasUnexaminedMarkup()) {
            size /= 2.0;
        }
        for (int i = 0; i < numColors; ++i) {
            int startX = (int)((double)i * size);
            int endX = (int)((double)(i + 1) * size);
            int width = endX - startX;
            this.drawBar(g, x + startX + this.BORDER + 1, y + this.BORDER + 1, width, colors.get(i));
        }
        g.setColor((Color)GThemeDefaults.Colors.BORDER);
        g.drawRect(x, y, this.WIDTH, this.HEIGHT);
        g.drawRect(x + this.WIDTH, y + this.HEIGHT / 2 - 3, this.KNOB_WIDTH, 6);
    }

    private void drawBar(Graphics g, int x, int y, int width, Color color) {
        g.setColor(color);
        g.fillRect(x, y, width, this.HEIGHT - 2 * this.BORDER - 1);
    }

    private List<Color> getColors(VTAssociationMarkupStatus markupStatus) {
        ArrayList<Color> list = new ArrayList<Color>(4);
        if (markupStatus.hasRejectedMarkup()) {
            list.add(BG_REJECTED);
        }
        if (markupStatus.hasAppliedMarkup() || markupStatus.isFullyApplied()) {
            list.add(BG_APPLIED);
        }
        if (markupStatus.hasDontCareMarkup()) {
            list.add(BG_DONT_CARE);
        }
        if (markupStatus.hasDontKnowMarkup()) {
            list.add(BG_DONT_KNOW);
        }
        return list;
    }
}

