/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.pattern;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.util.NumericUtilities;
import java.util.ArrayList;

public class PatternBlock {
    int offset;
    int nonzerosize;
    int[] maskvec;
    int[] valvec;
    protected static final int SHAMT = 24;
    protected static final int LEFT_BYTE = -16777216;

    private static int[] eraseArray(int[] array, int start, int end) {
        int i;
        int delsize = end - start;
        int newsize = array.length - delsize;
        int[] res = new int[newsize];
        for (i = 0; i < start; ++i) {
            res[i] = array[i];
        }
        for (i = end; i < array.length; ++i) {
            res[i - delsize] = array[i];
        }
        return res;
    }

    public int[] getMaskVector() {
        return this.maskvec;
    }

    public int[] getValueVector() {
        return this.valvec;
    }

    private void normalize() {
        if (this.nonzerosize <= 0) {
            this.offset = 0;
            this.maskvec = null;
            this.valvec = null;
            return;
        }
        int iter1 = 0;
        int iter2 = 0;
        while (iter1 != this.maskvec.length && this.maskvec[iter1] == 0) {
            ++iter1;
            ++iter2;
            this.offset += 4;
        }
        this.maskvec = PatternBlock.eraseArray(this.maskvec, 0, iter1);
        this.valvec = PatternBlock.eraseArray(this.valvec, 0, iter2);
        if (this.maskvec.length != 0) {
            int tmp;
            int suboff = 0;
            for (tmp = this.maskvec[0]; tmp != 0; tmp >>>= 8) {
                ++suboff;
            }
            if ((suboff = 4 - suboff) != 0) {
                int i;
                this.offset += suboff;
                for (i = 0; i < this.maskvec.length - 1; ++i) {
                    tmp = this.maskvec[i] << suboff * 8;
                    this.maskvec[i] = tmp |= this.maskvec[i + 1] >>> (4 - suboff) * 8;
                }
                int n = this.maskvec.length - 1;
                this.maskvec[n] = this.maskvec[n] << suboff * 8;
                for (i = 0; i < this.valvec.length - 1; ++i) {
                    tmp = this.valvec[i] << suboff * 8;
                    this.valvec[i] = tmp |= this.valvec[i] >>> (4 - suboff) * 8;
                }
                int n2 = this.valvec.length - 1;
                this.valvec[n2] = this.valvec[n2] << suboff * 8;
            }
            iter1 = this.maskvec.length;
            iter2 = this.valvec.length;
            while (iter1 != 0) {
                --iter2;
                if (this.maskvec[--iter1] == 0) continue;
            }
            if (iter1 != this.maskvec.length) {
                ++iter1;
                ++iter2;
            }
            this.maskvec = PatternBlock.eraseArray(this.maskvec, iter1, this.maskvec.length);
            this.valvec = PatternBlock.eraseArray(this.valvec, iter2, this.valvec.length);
        }
        if (this.maskvec.length == 0) {
            this.offset = 0;
            this.nonzerosize = 0;
            this.maskvec = null;
            this.valvec = null;
            return;
        }
        this.nonzerosize = this.maskvec.length * 4;
        int tmp = this.maskvec[this.maskvec.length - 1];
        while ((tmp & 0xFF) == 0) {
            --this.nonzerosize;
            tmp >>>= 8;
        }
    }

    public PatternBlock(int off, int msk, int val) {
        this.offset = off;
        this.maskvec = new int[1];
        this.maskvec[0] = msk;
        this.valvec = new int[1];
        this.valvec[0] = val;
        this.nonzerosize = 4;
        this.normalize();
    }

    public PatternBlock(boolean tf) {
        this.offset = 0;
        this.nonzerosize = tf ? 0 : -1;
        this.maskvec = null;
        this.valvec = null;
    }

    public PatternBlock(PatternBlock a, PatternBlock b) {
        PatternBlock res = a.andBlock(b);
        this.offset = res.offset;
        this.nonzerosize = res.nonzerosize;
        this.maskvec = (int[])res.maskvec.clone();
        this.valvec = (int[])res.valvec.clone();
    }

    public PatternBlock(ArrayList<?> list) {
        if (list.size() == 0) {
            this.offset = 0;
            this.nonzerosize = 0;
            this.maskvec = null;
            this.valvec = null;
            return;
        }
        PatternBlock res = (PatternBlock)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            res = res.andBlock((PatternBlock)list.get(i));
        }
        this.offset = res.offset;
        this.nonzerosize = res.nonzerosize;
        this.maskvec = (int[])res.maskvec.clone();
        this.valvec = (int[])res.valvec.clone();
    }

    public Object clone() {
        PatternBlock res = new PatternBlock(true);
        res.offset = this.offset;
        res.nonzerosize = this.nonzerosize;
        res.maskvec = (int[])this.maskvec.clone();
        res.valvec = (int[])this.valvec.clone();
        return res;
    }

    public PatternBlock andBlock(PatternBlock b) {
        PatternBlock res = new PatternBlock(true);
        int maxlength = this.getLength() > b.getLength() ? this.getLength() : b.getLength();
        int asize = maxlength / 4;
        if (maxlength % 4 != 0) {
            ++asize;
        }
        res.maskvec = new int[asize];
        res.valvec = new int[asize];
        res.offset = 0;
        int offset1 = 0;
        int i = 0;
        while (offset1 < maxlength) {
            int val2;
            int mask1 = this.getMask(offset1 * 8, 32);
            int val1 = this.getValue(offset1 * 8, 32);
            int mask2 = b.getMask(offset1 * 8, 32);
            if ((mask2 & mask1 & (val2 = b.getValue(offset1 * 8, 32))) != (mask2 & mask1 & val1)) break;
            res.maskvec[i] = mask1 | mask2;
            res.valvec[i] = val1 | val2;
            offset1 += 4;
            ++i;
        }
        res.nonzerosize = offset1 < maxlength ? -1 : maxlength;
        res.normalize();
        return res;
    }

    public boolean specializes(PatternBlock op2) {
        int tmplength;
        int length = 8 * op2.getLength();
        for (int sbit = 0; sbit < length; sbit += tmplength) {
            tmplength = length - sbit;
            if (tmplength > 32) {
                tmplength = 32;
            }
            int mask1 = this.getMask(sbit, tmplength);
            int value1 = this.getValue(sbit, tmplength);
            int mask2 = op2.getMask(sbit, tmplength);
            int value2 = op2.getValue(sbit, tmplength);
            if ((mask1 & mask2) != mask2) {
                return false;
            }
            if ((value1 & mask2) == (value2 & mask2)) continue;
            return false;
        }
        return true;
    }

    public boolean identical(PatternBlock op2) {
        int tmplength;
        int length = 8 * op2.getLength();
        for (int sbit = 0; sbit < length; sbit += tmplength) {
            tmplength = length - sbit;
            if (tmplength > 32) {
                tmplength = 32;
            }
            int mask1 = this.getMask(sbit, tmplength);
            int value1 = this.getValue(sbit, tmplength);
            int mask2 = op2.getMask(sbit, tmplength);
            int value2 = op2.getValue(sbit, tmplength);
            if (mask1 != mask2) {
                return false;
            }
            if ((mask1 & value1) == (mask2 & value2)) continue;
            return false;
        }
        return true;
    }

    public void shift(int sa) {
        this.offset += sa;
        this.normalize();
    }

    public int getLength() {
        return this.offset + this.nonzerosize;
    }

    public int getMask(int startbit, int size) {
        int wordnum1 = (startbit -= 8 * this.offset) / 32;
        int shift = startbit % 32;
        int wordnum2 = (startbit + size - 1) / 32;
        int res = wordnum1 < 0 || wordnum1 >= this.maskvec.length ? 0 : this.maskvec[wordnum1];
        res <<= shift;
        if (wordnum1 != wordnum2) {
            int tmp = wordnum2 < 0 || wordnum2 >= this.maskvec.length ? 0 : this.maskvec[wordnum2];
            res |= tmp >>> 32 - shift;
        }
        return res >>>= 32 - size;
    }

    public int getValue(int startbit, int size) {
        int wordnum1 = (startbit -= 8 * this.offset) / 32;
        int shift = startbit % 32;
        int wordnum2 = (startbit + size - 1) / 32;
        int res = wordnum1 < 0 || wordnum1 >= this.valvec.length ? 0 : this.valvec[wordnum1];
        res <<= shift;
        if (wordnum1 != wordnum2) {
            int tmp = wordnum2 < 0 || wordnum2 >= this.valvec.length ? 0 : this.valvec[wordnum2];
            res |= tmp >>> 32 - shift;
        }
        return res >>>= 32 - size;
    }

    public boolean alwaysTrue() {
        return this.nonzerosize == 0;
    }

    public boolean alwaysFalse() {
        return this.nonzerosize == -1;
    }

    public boolean isInstructionMatch(ParserWalker walker) {
        if (this.nonzerosize <= 0) {
            return this.nonzerosize == 0;
        }
        int off = this.offset;
        try {
            for (int i = 0; i < this.maskvec.length; ++i) {
                int data = walker.getInstructionBytes(off, 4);
                if ((this.maskvec[i] & data) != this.valvec[i]) {
                    return false;
                }
                off += 4;
            }
            return true;
        }
        catch (MemoryAccessException e) {
            return false;
        }
    }

    public boolean isContextMatch(ParserWalker walker) {
        if (this.nonzerosize <= 0) {
            return this.nonzerosize == 0;
        }
        int off = this.offset;
        for (int i = 0; i < this.maskvec.length; ++i) {
            int data = walker.getContextBytes(off, 4);
            if ((this.maskvec[i] & data) != this.valvec[i]) {
                return false;
            }
            off += 4;
        }
        return true;
    }

    public void decode(Decoder decoder) throws DecoderException {
        int el = decoder.openElement(SlaFormat.ELEM_PAT_BLOCK);
        this.offset = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_OFF);
        this.nonzerosize = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_NONZERO);
        ArrayList<Integer> masks = new ArrayList<Integer>();
        ArrayList<Integer> vals = new ArrayList<Integer>();
        while (decoder.peekElement() == SlaFormat.ELEM_MASK_WORD.id()) {
            decoder.openElement();
            masks.add((int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_MASK));
            vals.add((int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_VAL));
            decoder.closeElement(SlaFormat.ELEM_MASK_WORD.id());
        }
        this.maskvec = new int[masks.size()];
        this.valvec = new int[vals.size()];
        for (int i = 0; i < this.maskvec.length; ++i) {
            this.maskvec[i] = (Integer)masks.get(i);
            this.valvec[i] = (Integer)vals.get(i);
        }
        decoder.closeElement(el);
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.offset; ++i) {
            sb.append("SS:");
        }
        for (i = 0; i < this.maskvec.length; ++i) {
            if (i != 0) {
                sb.append(':');
            }
            sb.append(NumericUtilities.convertMaskedValueToHexString((long)this.maskvec[i], (long)this.valvec[i], (int)8, (boolean)false, (int)2, (String)":"));
        }
        if (sb.length() == 0) {
            return "[]";
        }
        return sb.toString();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getNonZeroLength() {
        return this.nonzerosize;
    }

    public byte[] getWholeBytes() {
        int count = 0;
        for (int i = 0; i < this.maskvec.length; ++i) {
            int mask = this.maskvec[i];
            for (int j = 0; j < 4; ++j) {
                if ((mask & 0xFF000000) == -16777216) {
                    ++count;
                }
                mask <<= 8;
            }
        }
        byte[] result = new byte[count];
        int pos = 0;
        for (int i = 0; i < this.maskvec.length; ++i) {
            int mask = this.maskvec[i];
            int valu = this.valvec[i];
            for (int j = 0; j < 4; ++j) {
                if ((mask & 0xFF000000) == -16777216) {
                    result[pos++] = (byte)((valu & 0xFF000000) >>> 24);
                }
                mask <<= 8;
                valu <<= 8;
            }
        }
        return result;
    }
}

