/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.som.SomSysClock;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomCompilationUnit
implements StructConverter {
    public static final int SIZE = 36;
    private String name;
    private String languageName;
    private String productId;
    private String versionId;
    private int reserved;
    private boolean chunkFlag;
    private SomSysClock compileTime;
    private SomSysClock sourceTime;

    public SomCompilationUnit(BinaryReader reader, long symbolStringsLocation) throws IOException {
        this.name = reader.readAsciiString(symbolStringsLocation + reader.readNextUnsignedInt());
        this.languageName = reader.readAsciiString(symbolStringsLocation + reader.readNextUnsignedInt());
        this.productId = reader.readAsciiString(symbolStringsLocation + reader.readNextUnsignedInt());
        this.versionId = reader.readAsciiString(symbolStringsLocation + reader.readNextUnsignedInt());
        int bitfield = reader.readNextInt();
        this.chunkFlag = (bitfield & 1) != 0;
        this.reserved = bitfield >> 1 & Integer.MAX_VALUE;
        this.compileTime = new SomSysClock(reader);
        this.sourceTime = new SomSysClock(reader);
    }

    public String getName() {
        return this.name;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public int getReserved() {
        return this.reserved;
    }

    public boolean getChunkFlag() {
        return this.chunkFlag;
    }

    public SomSysClock getCompileTime() {
        return this.compileTime;
    }

    public SomSysClock getSourceTime() {
        return this.sourceTime;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("compilation_unit", 36);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "name", null);
        struct.add(DWORD, "language_name", null);
        struct.add(DWORD, "product_id", null);
        struct.add(DWORD, "version_id", null);
        try {
            struct.addBitField(DWORD, 31, "reserved", null);
            struct.addBitField(DWORD, 1, "chunk_flag", null);
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(this.compileTime.toDataType(), "compile_time", null);
        struct.add(this.sourceTime.toDataType(), "source_time", null);
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

