/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMHierarchyRequestException;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMTypeInfo;
import io.sf.carte.doc.dom.NamespacedNode;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

abstract class DOMAttr
extends NamespacedNode
implements Attr {
    private static final long serialVersionUID = 1L;
    private TypeInfo schemaTypeInfo = null;
    private final String localName;
    boolean specified = true;
    String value = "";

    DOMAttr(String localName, String namespaceURI) {
        super((short)2, namespaceURI);
        this.localName = localName;
    }

    @Override
    void checkInsertNodeHierarchy(Node newChild, Node refNode) {
        throw new DOMHierarchyRequestException("Cannot append to attribute node");
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getName() {
        String name = this.getLocalName();
        String prefix = this.getPrefix();
        if (prefix != null) {
            name = prefix + ':' + name;
        }
        return name;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.setValue(nodeValue);
    }

    @Override
    public DOMElement getOwnerElement() {
        return (DOMElement)super.getParentNode();
    }

    @Override
    public DOMNode getParentNode() throws DOMException {
        return null;
    }

    @Override
    void setParentNode(AbstractDOMNode parentNode) throws DOMException {
        throw new DOMHierarchyRequestException("Attributes do no have a parent node");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.schemaTypeInfo == null) {
            this.schemaTypeInfo = new AttributeTypeInfo();
        }
        return this.schemaTypeInfo;
    }

    @Override
    public boolean getSpecified() {
        return this.specified;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        this.value = value;
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getValue();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.setValue(textContent);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        DOMElement owner;
        String namespaceURI = super.lookupNamespaceURI(prefix);
        if (namespaceURI == null && (owner = this.getOwnerElement()) != null) {
            namespaceURI = owner.lookupNamespaceURI(prefix);
        }
        return namespaceURI;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (namespaceURI.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        DOMElement parent = this.getOwnerElement();
        if (parent != null) {
            return parent.lookupPrefix(namespaceURI);
        }
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        if ("xmlns".equals(this.getLocalName()) || "xmlns".equals(prefix) && !"http://www.w3.org/2000/xmlns/".equals(this.getNamespaceURI())) {
            throw new DOMException(14, "Cannot set prefix to this node");
        }
        String oldPrefix = this.getPrefix();
        super.setPrefix(prefix);
        DOMElement parent = this.getOwnerElement();
        if (parent != null) {
            parent.nodeMap.updatePrefix(this, prefix, oldPrefix);
        }
    }

    @Override
    public abstract Attr cloneNode(boolean var1);

    public String toString() {
        StringBuilder buf;
        String name = this.getLocalName();
        String prefix = this.getPrefix();
        String value = this.getValue();
        int vlen = value.length();
        if (prefix != null) {
            buf = new StringBuilder(name.length() + prefix.length() + vlen + 4);
            buf.append(prefix);
            buf.append(':');
        } else {
            buf = new StringBuilder(name.length() + vlen + 3);
        }
        buf.append(name);
        if (vlen != 0 || !this.isBooleanAttribute()) {
            buf.append("=\"");
            buf.append(DOMAttr.escapeAttributeEntities(value));
            buf.append('\"');
        }
        return buf.toString();
    }

    boolean isBooleanAttribute() {
        String nsUri;
        return this.getOwnerDocument().isHTML() && ((nsUri = this.getNamespaceURI()) == null || nsUri == "http://www.w3.org/1999/xhtml");
    }

    void write(SimpleWriter wri) throws IOException {
        String qname = this.getLocalName();
        String prefix = this.getPrefix();
        if (prefix != null) {
            wri.write((CharSequence)prefix);
            wri.write(':');
        }
        wri.write((CharSequence)qname);
        String value = this.getValue();
        if (value.length() != 0) {
            wri.write((CharSequence)"=\"");
            wri.write((CharSequence)DOMAttr.escapeAttributeEntities(value));
            wri.write('\"');
        }
    }

    static String escapeAttributeEntities(String text) {
        StringBuilder buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                buf = DOMDocument.appendEntityToBuffer(buf, "lt", text, i, len);
                continue;
            }
            if (c == '>') {
                buf = DOMDocument.appendEntityToBuffer(buf, "gt", text, i, len);
                continue;
            }
            if (c == '&') {
                buf = DOMDocument.appendEntityToBuffer(buf, "amp", text, i, len);
                continue;
            }
            if (c == '\"') {
                buf = DOMDocument.appendEntityToBuffer(buf, "quot", text, i, len);
                continue;
            }
            if (c == '\u00a0') {
                buf = DOMDocument.appendEntityToBuffer(buf, "nbsp", text, i, len);
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            text = buf.toString();
        }
        return text;
    }

    private class AttributeTypeInfo
    extends DOMTypeInfo {
        private AttributeTypeInfo() {
        }

        @Override
        public String getTypeName() {
            if (DOMAttr.this.isId()) {
                return "ID";
            }
            return null;
        }

        @Override
        public String getTypeNamespace() {
            return "https://www.w3.org/TR/xml/";
        }
    }
}

