/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.svg.ExportVectorGraphic;
import org.freeplane.view.swing.map.MapView;
import org.w3c.dom.Document;

class ExportSvg
extends ExportVectorGraphic {
    private static final String SVG_EMBED_FONTS = "org.freeplane.plugin.svg.export.svg.embed_fonts";

    ExportSvg() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(List<NodeModel> branches, File chosenFile) {
        MapModel map = branches.get(0).getMap();
        if (!ExportController.getContoller().checkCurrentMap(map)) {
            return;
        }
        try {
            MapView view = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
            if (view == null) {
                return;
            }
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            SVGGraphics2D g2d = this.createSVGGraphics2D(view);
            try (FileOutputStream bos = new FileOutputStream(chosenFile);){
                BufferedOutputStream bufStream = new BufferedOutputStream(bos);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bufStream, "UTF-8");
                g2d.stream((Writer)osw);
                osw.flush();
            }
        }
        catch (Exception ex) {
            LogUtils.warn((Throwable)ex);
            UITools.errorMessage((Object)ex.getLocalizedMessage());
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    @Override
    protected SVGGeneratorContext createGeneratorContext(Document domFactory) {
        SVGGeneratorContext ctx = super.createGeneratorContext(domFactory);
        if (ResourceController.getResourceController().getBooleanProperty(SVG_EMBED_FONTS)) {
            ctx.setEmbeddedFontsOn(true);
        }
        return ctx;
    }
}

