import type { CodeMapping } from '@volar/language-core';
import type { DocumentDropEdit } from '@volar/language-service';
import * as protocol from 'vscode-languageserver-protocol';
export * from 'vscode-languageserver-protocol';
/**
 * Client request server
 */
export declare namespace FindFileReferenceRequest {
    type ParamsType = {
        textDocument: protocol.TextDocumentIdentifier;
    };
    type ResponseType = protocol.Location[] | null | undefined;
    type ErrorType = never;
    const type: protocol.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace GetMatchTsConfigRequest {
    type ParamsType = protocol.TextDocumentIdentifier;
    type ResponseType = {
        uri: string;
    } | null | undefined;
    type ErrorType = never;
    const type: protocol.RequestType<protocol.TextDocumentIdentifier, ResponseType, never>;
}
export declare namespace AutoInsertRequest {
    type ParamsType = {
        textDocument: protocol.TextDocumentIdentifier;
        selection: protocol.Position;
        change: {
            rangeOffset: number;
            rangeLength: number;
            text: string;
        };
    };
    type ResponseType = string | null | undefined;
    type ErrorType = never;
    const type: protocol.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace WriteVirtualFilesNotification {
    const type: protocol.NotificationType<protocol.TextDocumentIdentifier>;
}
export declare namespace ReloadProjectNotification {
    const type: protocol.NotificationType<protocol.TextDocumentIdentifier>;
}
/**
 * Document Drop
 */
export declare namespace DocumentDropRequest {
    type ParamsType = protocol.TextDocumentPositionParams & {
        dataTransfer: {
            mimeType: string;
            value: any;
            file?: {
                name: string;
                uri?: string;
            };
        }[];
    };
    type ResponseType = DocumentDropEdit | null | undefined;
    type ErrorType = never;
    const type: protocol.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace DocumentDrop_DataTransferItemAsStringRequest {
    type ParamsType = {
        mimeType: string;
    };
    type ResponseType = string;
    type ErrorType = never;
    const type: protocol.RequestType<ParamsType, string, never>;
}
export declare namespace DocumentDrop_DataTransferItemFileDataRequest {
    type ParamsType = {
        mimeType: string;
    };
    type ResponseType = Uint8Array;
    type ErrorType = never;
    const type: protocol.RequestType<ParamsType, ResponseType, never>;
}
/**
 * Labs
 */
export declare namespace UpdateVirtualCodeStateNotification {
    type ParamsType = {
        fileUri: string;
        virtualCodeId: string;
        disabled: boolean;
    };
    const type: protocol.NotificationType<ParamsType>;
}
export declare namespace UpdateServicePluginStateNotification {
    type ParamsType = {
        uri: string;
        serviceId: number;
        disabled: boolean;
    };
    const type: protocol.NotificationType<ParamsType>;
}
export declare namespace GetServicePluginsRequest {
    type ParamsType = protocol.TextDocumentIdentifier;
    type ResponseType = {
        id: number;
        name?: string;
        features: string[];
        disabled: boolean;
    }[] | null | undefined;
    type ErrorType = never;
    const type: protocol.RequestType<protocol.TextDocumentIdentifier, ResponseType, never>;
}
export declare namespace GetVirtualFileRequest {
    type VirtualCodeInfo = {
        fileUri: string;
        virtualCodeId: string;
        languageId: string;
        version: number;
        disabled: boolean;
        embeddedCodes: VirtualCodeInfo[];
    };
    type ParamsType = protocol.TextDocumentIdentifier;
    type ResponseType = VirtualCodeInfo | null | undefined;
    type ErrorType = never;
    const type: protocol.RequestType<protocol.TextDocumentIdentifier, ResponseType, never>;
}
export declare namespace GetVirtualCodeRequest {
    type ParamsType = {
        fileUri: string;
        virtualCodeId: string;
    };
    type ResponseType = {
        content: string;
        mappings: Record<string, CodeMapping[]>;
    };
    type ErrorType = never;
    const type: protocol.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace LoadedTSFilesMetaRequest {
    const type: protocol.RequestType0<unknown, unknown>;
}
