"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveReport = void 0;
var _uuid = require("uuid");
var _backendModel = require("../../model/backendModel");
var _uiToBackend = require("../utils/converters/uiToBackend");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const saveReport = async (report, opensearchReportsClient) => {
  const timePending = Date.now();
  const {
    time_from: timeFrom,
    time_to: timeTo,
    query_url: queryUrl,
    report_definition: reportDefinition
  } = report;
  const reqBody = {
    beginTimeMs: timeFrom,
    endTimeMs: timeTo,
    reportDefinitionDetails: {
      id: (0, _uuid.v1)(),
      lastUpdatedTimeMs: timePending,
      createdTimeMs: timePending,
      reportDefinition: {
        ...(0, _uiToBackend.uiToBackendReportDefinition)(reportDefinition),
        trigger: {
          triggerType: 'Download' // TODO: this is a corner case for in-context menu button download only
        }
      }
    },

    // download from in-context menu should always pass executing state to backend
    // TODO: set to success, since update report status API in temporarily unavailable, need change back to pending later
    status: _backendModel.BACKEND_REPORT_STATE.success,
    inContextDownloadUrlPath: queryUrl
  };
  const opensearchResp = await opensearchReportsClient.callAsCurrentUser('opensearch_reports.createReport', {
    body: reqBody
  });
  return opensearchResp;
};
exports.saveReport = saveReport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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