/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.IncrementalNextRoundException;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"checkPluginsArguments", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "useK2", "pluginClasspaths", "", "", "pluginOptions", "pluginConfigurations", "hasOOMCause", "", "reportCompilationCancelled", "", "e", "Lorg/jetbrains/kotlin/progress/CompilationCanceledException;", "cli"})
@SourceDebugExtension(value={"SMAP\nCLICompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLICompiler.kt\norg/jetbrains/kotlin/cli/common/CLICompilerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,502:1\n1915#2,2:503\n1915#2,2:505\n*S KotlinDebug\n*F\n+ 1 CLICompiler.kt\norg/jetbrains/kotlin/cli/common/CLICompilerKt\n*L\n478#1:503,2\n482#1:505,2\n*E\n"})
public final class CLICompilerKt {
    public static final boolean checkPluginsArguments(@NotNull MessageCollector messageCollector, boolean useK2, @NotNull List<String> pluginClasspaths, @NotNull List<String> pluginOptions, @NotNull List<String> pluginConfigurations) {
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(pluginClasspaths, "pluginClasspaths");
        Intrinsics.checkNotNullParameter(pluginOptions, "pluginOptions");
        Intrinsics.checkNotNullParameter(pluginConfigurations, "pluginConfigurations");
        boolean hasErrors = false;
        for (String classpath : pluginClasspaths) {
            if (new File(classpath).exists()) continue;
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Plugin classpath entry points to a non-existent location: " + classpath, null, 4, null);
        }
        if (!((Collection)pluginConfigurations).isEmpty()) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.WARNING, "Argument -Xcompiler-plugin is experimental", null, 4, null);
            if (!useK2) {
                hasErrors = true;
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, "-Xcompiler-plugin argument is allowed only for language version 2.0. Please use -Xplugin argument for language version 1.9 and below", null, 4, null);
            }
            if (!((Collection)pluginClasspaths).isEmpty() || !((Collection)pluginOptions).isEmpty()) {
                String it;
                StringBuilder stringBuilder;
                hasErrors = true;
                StringBuilder $this$checkPluginsArguments_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$checkPluginsArguments_u24lambda_u240.append("Mixing legacy and modern plugin arguments is prohibited. Please use only one syntax").append('\n');
                $this$checkPluginsArguments_u24lambda_u240.append("Legacy arguments:").append('\n');
                if (!((Collection)pluginClasspaths).isEmpty()) {
                    $this$checkPluginsArguments_u24lambda_u240.append("  -Xplugin=" + CollectionsKt.joinToString$default(pluginClasspaths, ",", null, null, 0, null, null, 62, null)).append('\n');
                }
                Iterable $this$forEach$iv = pluginOptions;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl2 = false;
                    $this$checkPluginsArguments_u24lambda_u240.append("  -P " + it).append('\n');
                }
                $this$checkPluginsArguments_u24lambda_u240.append("Modern arguments:").append('\n');
                $this$forEach$iv = pluginConfigurations;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (String)element$iv;
                    boolean bl3 = false;
                    $this$checkPluginsArguments_u24lambda_u240.append("  -Xcompiler-plugin=" + it).append('\n');
                }
                String message2 = stringBuilder.toString();
                MessageCollector.report$default(messageCollector, CompilerMessageSeverity.ERROR, message2, null, 4, null);
            }
        }
        return !hasErrors;
    }

    public static final boolean hasOOMCause(@NotNull Throwable $this$hasOOMCause) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$hasOOMCause, "<this>");
        if ($this$hasOOMCause.getCause() instanceof OutOfMemoryError) {
            bl = true;
        } else {
            Throwable throwable = $this$hasOOMCause.getCause();
            bl = throwable != null ? CLICompilerKt.hasOOMCause(throwable) : false;
        }
        return bl;
    }

    public static final void reportCompilationCancelled(@NotNull MessageCollector $this$reportCompilationCancelled, @NotNull CompilationCanceledException e2) {
        Intrinsics.checkNotNullParameter($this$reportCompilationCancelled, "<this>");
        Intrinsics.checkNotNullParameter(e2, "e");
        if (!(e2 instanceof IncrementalNextRoundException)) {
            $this$reportCompilationCancelled.report(CompilerMessageSeverity.INFO, "Compilation was canceled", null);
        }
    }
}

