/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBasedBackingFieldDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedClassConstructorDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedClassDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDelegateFieldDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedEnumEntryDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedFieldDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedPropertyDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedPropertyGetterDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedPropertySetterDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedReceiverParameterDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedTypeAliasDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedTypeParameterDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedValueParameterDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedVariableDescriptor;
import org.jetbrains.kotlin.ir.descriptors.IrBasedVariableDescriptorWithAccessor;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.DefinitelyNotNullType;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.StarProjectionImpl;
import org.jetbrains.kotlin.types.TypeProjectionBase;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00e8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0000\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0000\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\u0000\u001a\u00020\t*\u00020\n\u001a\n\u0010\u0000\u001a\u00020\u000b*\u00020\f\u001a\n\u0010\u0000\u001a\u00020\r*\u00020\u000e\u001a\n\u0010\u0000\u001a\u00020\u000f*\u00020\u0010\u001a\n\u0010\u0000\u001a\u00020\u0011*\u00020\u0012\u001a\n\u0010\u0000\u001a\u00020\u0013*\u00020\u0014\u001a\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\n\u0010\u0000\u001a\u00020\u001c*\u00020\u001d\u001a\n\u0010\u0000\u001a\u00020\u001e*\u00020\u001f\u001a\n\u0010\u0000\u001a\u00020 *\u00020\u0017\u001a\u0010\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0002H\u0002\u001a\u0016\u0010#\u001a\u00020$*\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'\u001a0\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010'H\u0002\u001a\f\u00100\u001a\u000201*\u000202H\u0002\u001a\f\u00100\u001a\u000203*\u000204H\u0002\u001a\f\u00100\u001a\u00020\u000f*\u000205H\u0002\u001a\f\u00100\u001a\u00020\u001b*\u000206H\u0002\u001a\f\u00100\u001a\u000207*\u000208H\u0002\u001a\f\u0010\u0000\u001a\u000207*\u000209H\u0002\u001a\u0010\u0010:\u001a\u0006\u0012\u0002\b\u00030;*\u00020<H\u0002\u001a\f\u0010=\u001a\u00020>*\u00020?H\u0002\u001a\f\u0010@\u001a\u00020A*\u00020\u0002H\u0002\u00a8\u0006B"}, d2={"toIrBasedDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedTypeParameterDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedVariableDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedVariableDescriptorWithAccessor;", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedSimpleFunctionDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedClassConstructorDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedClassDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedEnumEntryDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "toIrBackingFieldDescriptor", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedBackingFieldDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isDelegate", "", "correspondingProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedPropertyDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedTypeAliasDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "Lorg/jetbrains/kotlin/ir/descriptors/IrBasedFieldDescriptor;", "getContainingDeclaration", "declaration", "toIrBasedKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "builtins", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "makeKotlinType", "Lorg/jetbrains/kotlin/types/SimpleType;", "classifier", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "arguments", "", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "hasQuestionMark", "toIrBasedDescriptorIfPossible", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "Lorg/jetbrains/kotlin/ir/symbols/IrScriptSymbol;", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "toConstantValue", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lorg/jetbrains/kotlin/ir/IrElement;", "toAnnotationDescriptor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "toAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrBasedDescriptors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrBasedDescriptors.kt\norg/jetbrains/kotlin/ir/descriptors/IrBasedDescriptorsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1311:1\n1#2:1312\n24#3:1313\n16#3:1318\n16#3:1322\n16#3:1335\n1604#4,4:1314\n1634#4,3:1319\n1634#4,3:1323\n774#4:1326\n865#4,2:1327\n1193#4,2:1329\n1267#4,4:1331\n1634#4,3:1336\n*S KotlinDebug\n*F\n+ 1 IrBasedDescriptors.kt\norg/jetbrains/kotlin/ir/descriptors/IrBasedDescriptorsKt\n*L\n1189#1:1313\n1268#1:1318\n1301#1:1322\n1310#1:1335\n1189#1:1314,4\n1268#1:1319,3\n1301#1:1323,3\n1302#1:1326\n1302#1:1327,2\n1303#1:1329,2\n1303#1:1331,4\n1310#1:1336,3\n*E\n"})
public final class IrBasedDescriptorsKt {
    @NotNull
    public static final DeclarationDescriptor toIrBasedDescriptor(@NotNull IrDeclaration $this$toIrBasedDescriptor) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        IrDeclaration irDeclaration = $this$toIrBasedDescriptor;
        if (irDeclaration instanceof IrValueParameter) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrValueParameter)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrTypeParameter) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrTypeParameter)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrVariable) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrVariable)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrLocalDelegatedProperty) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrLocalDelegatedProperty)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrFunction) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrFunction)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrClass) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrClass)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrAnonymousInitializer) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor(IrUtilsKt.getParentAsClass($this$toIrBasedDescriptor));
        } else if (irDeclaration instanceof IrEnumEntry) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrEnumEntry)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrProperty) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrProperty)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrField) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrField)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrTypeAlias) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrTypeAlias)$this$toIrBasedDescriptor);
        } else if (irDeclaration instanceof IrScript) {
            declarationDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrScript)$this$toIrBasedDescriptor);
        } else {
            throw new IllegalStateException("Unknown declaration kind".toString());
        }
        return declarationDescriptor;
    }

    @NotNull
    public static final CallableDescriptor toIrBasedDescriptor(@NotNull IrValueParameter $this$toIrBasedDescriptor) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toIrBasedDescriptor.getKind().ordinal()]) {
            case 1: 
            case 2: {
                callableDescriptor = new IrBasedReceiverParameterDescriptor($this$toIrBasedDescriptor);
                break;
            }
            case 3: 
            case 4: {
                callableDescriptor = new IrBasedValueParameterDescriptor($this$toIrBasedDescriptor);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return callableDescriptor;
    }

    @NotNull
    public static final IrBasedTypeParameterDescriptor toIrBasedDescriptor(@NotNull IrTypeParameter $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return new IrBasedTypeParameterDescriptor($this$toIrBasedDescriptor);
    }

    @NotNull
    public static final IrBasedVariableDescriptor toIrBasedDescriptor(@NotNull IrVariable $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return new IrBasedVariableDescriptor($this$toIrBasedDescriptor);
    }

    @NotNull
    public static final IrBasedVariableDescriptorWithAccessor toIrBasedDescriptor(@NotNull IrLocalDelegatedProperty $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return new IrBasedVariableDescriptorWithAccessor($this$toIrBasedDescriptor);
    }

    @NotNull
    public static final IrBasedSimpleFunctionDescriptor toIrBasedDescriptor(@NotNull IrSimpleFunction $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return AdditionalIrUtilsKt.isGetter($this$toIrBasedDescriptor) ? (IrBasedSimpleFunctionDescriptor)new IrBasedPropertyGetterDescriptor($this$toIrBasedDescriptor) : (AdditionalIrUtilsKt.isSetter($this$toIrBasedDescriptor) ? (IrBasedSimpleFunctionDescriptor)new IrBasedPropertySetterDescriptor($this$toIrBasedDescriptor) : new IrBasedSimpleFunctionDescriptor($this$toIrBasedDescriptor));
    }

    @NotNull
    public static final IrBasedClassConstructorDescriptor toIrBasedDescriptor(@NotNull IrConstructor $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return new IrBasedClassConstructorDescriptor($this$toIrBasedDescriptor);
    }

    @NotNull
    public static final FunctionDescriptor toIrBasedDescriptor(@NotNull IrFunction $this$toIrBasedDescriptor) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        IrFunction irFunction = $this$toIrBasedDescriptor;
        if (irFunction instanceof IrSimpleFunction) {
            functionDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrSimpleFunction)$this$toIrBasedDescriptor);
        } else if (irFunction instanceof IrConstructor) {
            functionDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptor((IrConstructor)$this$toIrBasedDescriptor);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return functionDescriptor;
    }

    @NotNull
    public static final IrBasedClassDescriptor toIrBasedDescriptor(@NotNull IrClass $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return new IrBasedClassDescriptor($this$toIrBasedDescriptor);
    }

    @NotNull
    public static final IrBasedEnumEntryDescriptor toIrBasedDescriptor(@NotNull IrEnumEntry $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return new IrBasedEnumEntryDescriptor($this$toIrBasedDescriptor);
    }

    private static final IrBasedBackingFieldDescriptor toIrBackingFieldDescriptor(IrField $this$toIrBackingFieldDescriptor, boolean isDelegate, PropertyDescriptor correspondingProperty) {
        return isDelegate == Intrinsics.areEqual($this$toIrBackingFieldDescriptor.getOrigin(), IrDeclarationOrigin.Companion.getPROPERTY_DELEGATE()) ? new IrBasedBackingFieldDescriptor($this$toIrBackingFieldDescriptor, correspondingProperty) : null;
    }

    @NotNull
    public static final IrBasedPropertyDescriptor toIrBasedDescriptor(@NotNull IrProperty $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return new IrBasedPropertyDescriptor($this$toIrBasedDescriptor);
    }

    @NotNull
    public static final IrBasedTypeAliasDescriptor toIrBasedDescriptor(@NotNull IrTypeAlias $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return new IrBasedTypeAliasDescriptor($this$toIrBasedDescriptor);
    }

    @NotNull
    public static final IrBasedFieldDescriptor toIrBasedDescriptor(@NotNull IrField $this$toIrBasedDescriptor) {
        Intrinsics.checkNotNullParameter($this$toIrBasedDescriptor, "<this>");
        return Intrinsics.areEqual($this$toIrBasedDescriptor.getOrigin(), IrDeclarationOrigin.Companion.getDELEGATE()) ? (IrBasedFieldDescriptor)new IrBasedDelegateFieldDescriptor($this$toIrBasedDescriptor) : new IrBasedFieldDescriptor($this$toIrBasedDescriptor);
    }

    private static final DeclarationDescriptor getContainingDeclaration(IrDeclaration declaration) {
        DeclarationDescriptor declarationDescriptor;
        IrProperty irProperty;
        IrPropertySymbol irPropertySymbol;
        IrDeclarationParent parent2 = declaration.getParent();
        if (declaration instanceof IrTypeParameter && parent2 instanceof IrSimpleFunction && (irPropertySymbol = ((IrSimpleFunction)parent2).getCorrespondingPropertySymbol()) != null && (irProperty = (IrProperty)irPropertySymbol.getOwner()) != null) {
            IrProperty it = irProperty;
            boolean bl = false;
            return IrBasedDescriptorsKt.toIrBasedDescriptor(it);
        }
        Intrinsics.checkNotNull(parent2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
        IrSymbolOwner it = (IrSymbolOwner)((Object)parent2);
        boolean bl = false;
        DeclarationDescriptor parentDescriptor = it instanceof IrDeclaration ? IrBasedDescriptorsKt.toIrBasedDescriptor((IrDeclaration)it) : it.getSymbol().getDescriptor();
        if (parent2 instanceof IrClass && IrUtilsKt.isFileClass((IrDeclaration)((Object)parent2))) {
            DeclarationDescriptor declarationDescriptor2 = parentDescriptor.getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkNotNull(declarationDescriptor2);
        } else {
            declarationDescriptor = parentDescriptor;
        }
        return declarationDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final KotlinType toIrBasedKotlinType(@NotNull IrType $this$toIrBasedKotlinType, @Nullable KotlinBuiltIns builtins) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$toIrBasedKotlinType, "<this>");
        IrType irType = $this$toIrBasedKotlinType;
        if (irType instanceof IrSimpleType) {
            SimpleType simpleType;
            SimpleType it = IrBasedDescriptorsKt.makeKotlinType(((IrSimpleType)$this$toIrBasedKotlinType).getClassifier(), ((IrSimpleType)$this$toIrBasedKotlinType).getArguments(), IrTypePredicatesKt.isMarkedNullable((IrSimpleType)$this$toIrBasedKotlinType), builtins);
            boolean bl = false;
            if (((IrSimpleType)$this$toIrBasedKotlinType).getClassifier() instanceof IrTypeParameterSymbol && ((IrSimpleType)$this$toIrBasedKotlinType).getNullability() == SimpleTypeNullability.DEFINITELY_NOT_NULL) {
                DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, it.unwrap(), false, true, 2, null);
                simpleType = definitelyNotNullType != null ? (SimpleType)definitelyNotNullType : it;
            } else {
                simpleType = it;
            }
            kotlinType = simpleType;
            return kotlinType;
        } else if (irType instanceof IrDynamicType) {
            DynamicType dynamicType;
            kotlinType = $this$toIrBasedKotlinType.getOriginalKotlinType();
            if (kotlinType != null) return kotlinType;
            KotlinBuiltIns kotlinBuiltIns = builtins;
            if (kotlinBuiltIns != null) {
                KotlinBuiltIns p0 = kotlinBuiltIns;
                boolean bl = false;
                dynamicType = DynamicTypesKt.createDynamicType(p0);
            } else {
                dynamicType = null;
            }
            if (dynamicType == null) throw new IllegalStateException("Couldn't instantiate DynamicType".toString());
            kotlinType = dynamicType;
            return kotlinType;
        } else {
            if (!(irType instanceof IrErrorType)) throw new NoWhenBranchMatchedException();
            kotlinType = $this$toIrBasedKotlinType.getOriginalKotlinType();
            if (kotlinType != null) return kotlinType;
            String string = "Can't find KotlinType in IrErrorType: " + RenderIrElementKt.render$default($this$toIrBasedKotlinType, null, 1, null);
            throw new IllegalStateException(string.toString());
        }
    }

    public static /* synthetic */ KotlinType toIrBasedKotlinType$default(IrType irType, KotlinBuiltIns kotlinBuiltIns, int n2, Object object) {
        if ((n2 & 1) != 0) {
            kotlinBuiltIns = null;
        }
        return IrBasedDescriptorsKt.toIrBasedKotlinType(irType, kotlinBuiltIns);
    }

    /*
     * WARNING - void declaration
     */
    private static final SimpleType makeKotlinType(IrClassifierSymbol classifier, List<? extends IrTypeArgument> arguments, boolean hasQuestionMark, KotlinBuiltIns builtins) {
        SimpleType simpleType;
        IrClassifierSymbol irClassifierSymbol = classifier;
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            simpleType = IrBasedDescriptorsKt.toIrBasedDescriptorIfPossible((IrTypeParameterSymbol)classifier).getDefaultType().makeNullableAsSpecified(hasQuestionMark);
        } else if (irClassifierSymbol instanceof IrClassSymbol) {
            SimpleType simpleType2;
            void $this$mapIndexedTo$iv$iv;
            ClassDescriptor classDescriptor = IrBasedDescriptorsKt.toIrBasedDescriptorIfPossible((IrClassSymbol)classifier);
            Collection $this$memoryOptimizedMapIndexed$iv = arguments;
            boolean $i$f$memoryOptimizedMapIndexed = false;
            Iterable iterable = $this$memoryOptimizedMapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMapIndexed$iv.size());
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                TypeProjectionBase typeProjectionBase;
                void it;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
                int n3 = n2;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var19_19 = it;
                if (var19_19 instanceof IrTypeProjection) {
                    typeProjectionBase = new TypeProjectionImpl(((IrTypeProjection)it).getVariance(), IrBasedDescriptorsKt.toIrBasedKotlinType(((IrTypeProjection)it).getType(), builtins));
                } else if (var19_19 instanceof IrStarProjection) {
                    void index;
                    TypeParameterDescriptor typeParameterDescriptor = classDescriptor.getTypeConstructor().getParameters().get((int)index);
                    Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "get(...)");
                    typeProjectionBase = new StarProjectionImpl(typeParameterDescriptor);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(typeProjectionBase);
            }
            List kotlinTypeArguments = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            try {
                SimpleType simpleType3 = classDescriptor.getDefaultType();
                Intrinsics.checkNotNullExpressionValue(simpleType3, "getDefaultType(...)");
                simpleType2 = TypeSubstitutionKt.replace$default(simpleType3, kotlinTypeArguments, null, 2, null).makeNullableAsSpecified(hasQuestionMark);
            }
            catch (Throwable e2) {
                StringBuilder stringBuilder = new StringBuilder().append("Classifier: ").append(RenderIrElementKt.render$default((IrElement)((IrClassSymbol)classifier).getOwner(), null, 1, null)).append("\nType parameters:\n");
                List<TypeParameterDescriptor> list = classDescriptor.getDefaultType().getConstructor().getParameters();
                Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
                throw new RuntimeException(stringBuilder.append(CollectionsKt.joinToString$default(CollectionsKt.withIndex((Iterable)list), "\n", null, null, 0, null, IrBasedDescriptorsKt::makeKotlinType$lambda$1, 30, null)).append("\nType arguments:\n").append(CollectionsKt.joinToString$default(CollectionsKt.withIndex((Iterable)arguments), "\n", null, null, 0, null, IrBasedDescriptorsKt::makeKotlinType$lambda$2, 30, null)).toString(), e2);
            }
            simpleType = simpleType2;
        } else if (irClassifierSymbol instanceof IrScriptSymbol) {
            simpleType = TypeUtils.makeUnsubstitutedType(IrBasedDescriptorsKt.toIrBasedDescriptorIfPossible((IrScriptSymbol)classifier), (MemberScope)MemberScope.Empty.INSTANCE, KotlinTypeFactory.INSTANCE.getEMPTY_REFINED_TYPE_FACTORY()).makeNullableAsSpecified(hasQuestionMark);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return simpleType;
    }

    private static final ClassDescriptor toIrBasedDescriptorIfPossible(IrClassSymbol $this$toIrBasedDescriptorIfPossible) {
        return $this$toIrBasedDescriptorIfPossible.isBound() ? (ClassDescriptor)IrBasedDescriptorsKt.toIrBasedDescriptor((IrClass)$this$toIrBasedDescriptorIfPossible.getOwner()) : (ClassDescriptor)$this$toIrBasedDescriptorIfPossible.getDescriptor();
    }

    private static final TypeParameterDescriptor toIrBasedDescriptorIfPossible(IrTypeParameterSymbol $this$toIrBasedDescriptorIfPossible) {
        return $this$toIrBasedDescriptorIfPossible.isBound() ? (TypeParameterDescriptor)IrBasedDescriptorsKt.toIrBasedDescriptor((IrTypeParameter)$this$toIrBasedDescriptorIfPossible.getOwner()) : (TypeParameterDescriptor)$this$toIrBasedDescriptorIfPossible.getDescriptor();
    }

    private static final ScriptDescriptor toIrBasedDescriptorIfPossible(IrScriptSymbol $this$toIrBasedDescriptorIfPossible) {
        return (ScriptDescriptor)$this$toIrBasedDescriptorIfPossible.getDescriptor();
    }

    private static final ScriptDescriptor toIrBasedDescriptor(IrScript $this$toIrBasedDescriptor) {
        return $this$toIrBasedDescriptor.getDescriptor();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ConstantValue<?> toConstantValue(IrElement $this$toConstantValue) {
        ConstantValue constantValue;
        IrElement irElement = $this$toConstantValue;
        if (irElement instanceof IrConst) {
            IrConstKind irConstKind = ((IrConst)$this$toConstantValue).getKind();
            if (Intrinsics.areEqual(irConstKind, IrConstKind.Null.INSTANCE)) {
                constantValue = new NullValue();
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Boolean.INSTANCE)) {
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
                constantValue = new BooleanValue((Boolean)object);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Char.INSTANCE)) {
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Char");
                constantValue = new CharValue(((Character)object).charValue());
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Byte.INSTANCE)) {
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Byte");
                constantValue = new ByteValue((Byte)object);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Short.INSTANCE)) {
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Short");
                constantValue = new ShortValue((Short)object);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Int.INSTANCE)) {
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
                constantValue = new IntValue((Integer)object);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Long.INSTANCE)) {
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Long");
                constantValue = new LongValue((Long)object);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.String.INSTANCE)) {
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
                constantValue = new StringValue((String)object);
                return constantValue;
            } else if (Intrinsics.areEqual(irConstKind, IrConstKind.Float.INSTANCE)) {
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Float");
                constantValue = new FloatValue(((Float)object).floatValue());
                return constantValue;
            } else {
                if (!Intrinsics.areEqual(irConstKind, IrConstKind.Double.INSTANCE)) throw new NoWhenBranchMatchedException();
                Object object = ((IrConst)$this$toConstantValue).getValue();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Double");
                constantValue = new DoubleValue((Double)object);
            }
            return constantValue;
        } else if (irElement instanceof IrVararg) {
            void $this$mapTo$iv$iv;
            Collection $this$memoryOptimizedMap$iv = ((IrVararg)$this$toConstantValue).getElements();
            boolean $i$f$memoryOptimizedMap = false;
            Iterable iterable = $this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (it instanceof IrSpreadElement) {
                    throw new IllegalStateException((it + " is not expected").toString());
                }
                collection.add(IrBasedDescriptorsKt.toConstantValue((IrElement)it));
            }
            List elements = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
            constantValue = new ArrayValue(elements, IrBasedDescriptorsKt::toConstantValue$lambda$1);
            return constantValue;
        } else if (irElement instanceof IrGetEnumValue) {
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)IrBasedDescriptorsKt.toIrBasedDescriptor(IrUtilsKt.getParentAsClass((IrDeclaration)((IrGetEnumValue)$this$toConstantValue).getSymbol().getOwner())));
            Intrinsics.checkNotNull(classId);
            constantValue = new EnumValue(classId, ((IrEnumEntry)((IrGetEnumValue)$this$toConstantValue).getSymbol().getOwner()).getName());
            return constantValue;
        } else if (irElement instanceof IrClassReference) {
            IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(((IrClassReference)$this$toConstantValue).getClassType()).getOwner();
            Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)IrBasedDescriptorsKt.toIrBasedDescriptor((IrClass)irSymbolOwner));
            Intrinsics.checkNotNull(classId);
            constantValue = new KClassValue(classId, 0);
            return constantValue;
        } else {
            if (!(irElement instanceof IrConstructorCall)) throw new IllegalStateException(($this$toConstantValue + " is not expected: " + DumpIrTreeKt.dump$default($this$toConstantValue, null, 1, null)).toString());
            constantValue = new AnnotationValue(IrBasedDescriptorsKt.toAnnotationDescriptor((IrConstructorCall)$this$toConstantValue));
        }
        return constantValue;
    }

    /*
     * WARNING - void declaration
     */
    private static final AnnotationDescriptor toAnnotationDescriptor(IrConstructorCall $this$toAnnotationDescriptor) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Pair it;
        void $this$mapTo$iv$iv;
        Iterable $this$memoryOptimizedMap$iv;
        IrClass annotationClass = IrUtilsKt.getParentAsClass((IrDeclaration)$this$toAnnotationDescriptor.getSymbol().getOwner());
        if (Intrinsics.areEqual(annotationClass.getSymbol().getDescriptor(), ErrorUtils.INSTANCE.getErrorClass()) || $this$toAnnotationDescriptor.getType() instanceof IrErrorType) {
            return new AnnotationDescriptorImpl(IrTypesKt.toKotlinType($this$toAnnotationDescriptor.getType()), MapsKt.emptyMap(), $this$toAnnotationDescriptor.getSource());
        }
        boolean bl = IrUtilsKt.isAnnotationClass(annotationClass);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-IrBasedDescriptorsKt$toAnnotationDescriptor$22 = false;
            String $i$a$-assert-IrBasedDescriptorsKt$toAnnotationDescriptor$22 = "Expected call to constructor of annotation class but was: " + DumpIrTreeKt.dump$default($this$toAnnotationDescriptor, null, 1, null);
            throw new AssertionError((Object)$i$a$-assert-IrBasedDescriptorsKt$toAnnotationDescriptor$22);
        }
        Collection collection = ((IrConstructor)$this$toAnnotationDescriptor.getSymbol().getOwner()).getParameters();
        KotlinType kotlinType = IrBasedDescriptorsKt.toIrBasedKotlinType$default(IrUtilsKt.getDefaultType(annotationClass), null, 1, null);
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = $this$memoryOptimizedMap$iv;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(TuplesKt.to(it.getName(), $this$toAnnotationDescriptor.getArguments().get(((IrValueParameter)((Object)it)).getIndexInParameters())));
        }
        $this$memoryOptimizedMap$iv = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getSecond() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl4 = false;
            Object a2 = it2.getFirst();
            Object b2 = it2.getSecond();
            Intrinsics.checkNotNull(b2);
            Pair pair = TuplesKt.to(a2, IrBasedDescriptorsKt.toConstantValue((IrElement)b2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        SourceElement sourceElement = $this$toAnnotationDescriptor.getSource();
        Map map = destination$iv$iv2;
        KotlinType kotlinType2 = kotlinType;
        return new AnnotationDescriptorImpl(kotlinType2, map, sourceElement);
    }

    /*
     * WARNING - void declaration
     */
    private static final Annotations toAnnotations(IrDeclaration $this$toAnnotations) {
        void $this$mapTo$iv$iv;
        void $this$memoryOptimizedMap$iv;
        Object object = $this$toAnnotations instanceof IrAnnotationContainer ? (IrAnnotationContainer)$this$toAnnotations : null;
        if (object == null || (object = object.getAnnotations()) == null) {
            return Annotations.Companion.getEMPTY();
        }
        Object ownerAnnotations = object;
        Collection collection = (Collection)ownerAnnotations;
        Annotations.Companion companion = Annotations.Companion;
        boolean $i$f$memoryOptimizedMap = false;
        Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
        Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(IrBasedDescriptorsKt.toAnnotationDescriptor((IrConstructorCall)p0));
        }
        return companion.create(org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)destination$iv$iv));
    }

    private static final CharSequence makeKotlinType$lambda$1(IndexedValue it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object t2 = it.getValue();
        Intrinsics.checkNotNull(t2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.descriptors.IrBasedTypeParameterDescriptor");
        IrTypeParameter irTypeParameter = (IrTypeParameter)((IrBasedTypeParameterDescriptor)t2).getOwner();
        return it.getIndex() + ": " + RenderIrElementKt.render$default(irTypeParameter, null, 1, null) + " of " + RenderIrElementKt.render$default(irTypeParameter.getParent(), null, 1, null);
    }

    private static final CharSequence makeKotlinType$lambda$2(IndexedValue it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getIndex() + ": " + RenderIrElementKt.render$default((IrTypeArgument)it.getValue(), null, 1, null);
    }

    private static final KotlinType toConstantValue$lambda$1(ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        SimpleType simpleType = moduleDescriptor.getBuiltIns().getArray().getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType, "getDefaultType(...)");
        return simpleType;
    }

    public static final /* synthetic */ DeclarationDescriptor access$getContainingDeclaration(IrDeclaration declaration) {
        return IrBasedDescriptorsKt.getContainingDeclaration(declaration);
    }

    public static final /* synthetic */ Annotations access$toAnnotations(IrDeclaration $receiver) {
        return IrBasedDescriptorsKt.toAnnotations($receiver);
    }

    public static final /* synthetic */ IrBasedBackingFieldDescriptor access$toIrBackingFieldDescriptor(IrField $receiver, boolean isDelegate, PropertyDescriptor correspondingProperty) {
        return IrBasedDescriptorsKt.toIrBackingFieldDescriptor($receiver, isDelegate, correspondingProperty);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrParameterKind.values().length];
            try {
                nArray[IrParameterKind.DispatchReceiver.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.ExtensionReceiver.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Context.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Regular.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

