/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.ClientSessionManager;
import org.keycloak.models.sessions.infinispan.changes.ClientSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.EmbeddedClientSessionKey;

public class AuthenticatedClientSessionAdapter
implements AuthenticatedClientSessionModel {
    private final KeycloakSession kcSession;
    private final AuthenticatedClientSessionEntity entity;
    private final ClientModel client;
    private final ClientSessionManager clientSessionManager;
    private UserSessionModel userSession;
    private final boolean offline;
    private final EmbeddedClientSessionKey cacheKey;

    public AuthenticatedClientSessionAdapter(KeycloakSession kcSession, AuthenticatedClientSessionEntity entity, ClientModel client, UserSessionModel userSession, ClientSessionManager clientSessionManager, EmbeddedClientSessionKey cacheKey, boolean offline) {
        this.userSession = Objects.requireNonNull(userSession, "userSession must not be null");
        this.kcSession = kcSession;
        this.entity = entity;
        this.client = client;
        this.clientSessionManager = clientSessionManager;
        this.offline = offline;
        this.cacheKey = cacheKey;
    }

    private void update(ClientSessionUpdateTask task) {
        this.clientSessionManager.addChange(this.cacheKey, task);
    }

    public void detachFromUserSession() {
        if (this.userSession.isOffline()) {
            ((UserSessionPersisterProvider)this.kcSession.getProvider(UserSessionPersisterProvider.class)).removeClientSession(this.userSession.getId(), this.client.getId(), true);
        }
        this.userSession = null;
        this.clientSessionManager.addChange(this.cacheKey, Tasks.removeSync(this.offline));
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(final String uri) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setRedirectUri(uri);
            }

            @Override
            public boolean isOffline() {
                return AuthenticatedClientSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public String getId() {
        return this.cacheKey.toId();
    }

    public RealmModel getRealm() {
        return this.userSession.getRealm();
    }

    public ClientModel getClient() {
        return this.client;
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(final int timestamp) {
        if (timestamp <= this.getTimestamp()) {
            return;
        }
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                if (entity.getTimestamp() >= timestamp) {
                    return;
                }
                entity.setTimestamp(timestamp);
            }

            @Override
            public boolean isOffline() {
                return AuthenticatedClientSessionAdapter.this.offline;
            }

            public String toString() {
                return "setTimestamp(" + timestamp + ")";
            }
        };
        this.update(task);
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(final String action) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setAction(action);
            }

            @Override
            public boolean isOffline() {
                return AuthenticatedClientSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public String getProtocol() {
        return this.entity.getAuthMethod();
    }

    public void setProtocol(final String method) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setAuthMethod(method);
            }

            @Override
            public boolean isOffline() {
                return AuthenticatedClientSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public String getNote(String name) {
        return this.entity.getNotes().get(name);
    }

    public void setNote(final String name, final String value) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.getNotes().put(name, value);
            }

            @Override
            public boolean isOffline() {
                return AuthenticatedClientSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public void removeNote(final String name) {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                entity.getNotes().remove(name);
            }

            @Override
            public boolean isOffline() {
                return AuthenticatedClientSessionAdapter.this.offline;
            }
        };
        this.update(task);
    }

    public Map<String, String> getNotes() {
        return new ConcurrentHashMap<String, String>(this.entity.getNotes());
    }

    public void restartClientSession() {
        ClientSessionUpdateTask task = new ClientSessionUpdateTask(){

            @Override
            public void runUpdate(AuthenticatedClientSessionEntity entity) {
                UserSessionModel userSession = AuthenticatedClientSessionAdapter.this.getUserSession();
                entity.setAction(null);
                entity.setRedirectUri(null);
                entity.setTimestamp(Time.currentTime());
                entity.getNotes().clear();
                entity.getNotes().put("startedAt", String.valueOf(entity.getTimestamp()));
                entity.getNotes().put("userSessionStartedAt", String.valueOf(userSession.getStarted()));
                entity.getNotes().put("clientId", AuthenticatedClientSessionAdapter.this.getClient().getId());
                if (userSession.isRememberMe()) {
                    entity.getNotes().put("userSessionRememberMe", "true");
                }
            }

            @Override
            public boolean isOffline() {
                return AuthenticatedClientSessionAdapter.this.offline;
            }
        };
        this.clientSessionManager.restartEntity(this.cacheKey, task);
    }
}

