/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.asn1;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ElytronMessages;

public class OidsUtil {
    private static Map<Category, Map<String, String>> attributeNameToOidTable = new HashMap<Category, Map<String, String>>();
    private static Map<Category, Map<String, String>> oidToAttributeNameTable = new HashMap<Category, Map<String, String>>();

    public static String attributeNameToOid(Category category, String attributeName) {
        Assert.checkNotNullParam((String)"category", (Object)((Object)category));
        Assert.checkNotNullParam((String)"attributeName", (Object)attributeName);
        return attributeNameToOidTable.get((Object)category).get(attributeName.toUpperCase(Locale.ROOT));
    }

    public static String oidToAttributeName(Category category, String oid) {
        Assert.checkNotNullParam((String)"category", (Object)((Object)category));
        Assert.checkNotNullParam((String)"oid", (Object)oid);
        return oidToAttributeNameTable.get((Object)category).get(oid);
    }

    static {
        for (Category category : Category.values()) {
            attributeNameToOidTable.put(category, new HashMap());
            oidToAttributeNameTable.put(category, new HashMap());
        }
        try (InputStream stream = OidsUtil.class.getResourceAsStream("oids.properties");){
            Properties props = new Properties();
            props.load(stream);
            for (String propName : props.stringPropertyNames()) {
                String[] attributeNames;
                int delimiter = propName.indexOf(46);
                if (delimiter < 0) {
                    throw new IllegalStateException();
                }
                Category category = Category.valueOf(propName.substring(0, delimiter));
                String oid = propName.substring(delimiter + 1);
                for (String attributeName : attributeNames = props.getProperty(propName).split(",")) {
                    attributeNameToOidTable.get((Object)category).put(attributeName, oid);
                }
                oidToAttributeNameTable.get((Object)category).put(oid, attributeNames[0]);
            }
        }
        catch (Exception e) {
            throw ElytronMessages.log.unableToLoadOidsFromPropertiesFile(e);
        }
    }

    public static enum Category {
        RDN,
        GSS;

    }
}

