---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 単一のマージリクエストに含まれるプッシュを比較するには、差分バージョンを使用します。
title: マージリクエストの差分のバージョン
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

マージリクエストを作成する際、比較する2つのブランチを選択します。2つのブランチ間の差分は、マージリクエストで差分として表示されます。コミットをマージリクエストに接続されたブランチにプッシュするたびに、GitLabはマージリクエストの差分を新しい差分バージョンに更新します。

{{< alert type="note" >}}

差分バージョンは、各コミットではなく、各プッシュで更新されます。1つのプッシュに複数のコミットが含まれている場合、作成される新しい差分バージョンは1つだけです。

{{< /alert >}}

デフォルトでは、GitLabはソースブランチ（`feature`）の最新のプッシュを、ターゲットブランチ（通常は`main`）の最新のコミットと比較します。

## 差分バージョンを比較する {#compare-diff-versions}

ブランチに複数回プッシュした場合、以前の各プッシュからの差分バージョンを比較できます。マージリクエストに多くの変更が含まれている場合、または同じファイルへの連続した変更が含まれている場合は、より少ない数の変更を比較すると便利な場合があります。

前提要件:

- マージリクエストのブランチには、複数のプッシュからのコミットが含まれている必要があります。同じプッシュ内の個々のコミットは、新しい差分バージョンを生成しません。

差分バージョンを比較するには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **コード** > **マージリクエスト**を選択します。
1. マージリクエストを選択します。
1. このマージリクエストの現在の差分バージョンを表示するには、**変更**を選択します。
1. **比較**（{{< icon name="file-tree" >}}）の横で、比較するプッシュを選択します。この例では、`main`をブランチの最新のプッシュ（最新の差分バージョン）と比較します:

   ![マージリクエストバージョンドロップダウンリスト](img/versions_dropdown_v16_6.png)

   この例のブランチには4つのコミットがありますが、2つのコミットが同時にプッシュされたため、ブランチには3つの差分バージョンしか含まれていません。

## システムノートから差分バージョンを表示する {#view-diff-versions-from-a-system-note}

GitLabは、マージリクエストのブランチに新しい変更をプッシュするたびに、システムノートをマージリクエストに追加します。この例では、1回のプッシュで2つのコミットが追加されています:

![マージリクエストバージョンシステムノート](img/versions_system_note_v16_6.png)

そのコミットの差分を表示するには、コミットセキュアハッシュアルゴリズムを選択します。

詳細については、[マージリクエストでシステムノートを表示またはフィルタリングする方法](../system_notes.md#on-a-merge-request)を参照してください。

## 関連トピック {#related-topics}

- [管理者向けのマージリクエストの差分ストレージ](../../../administration/merge_request_diffs.md)
