/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.modules.syntax;

import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ArchRule;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.syntax.ClassesThatInternal;
import com.tngtech.archunit.lang.syntax.elements.ClassesThat;
import com.tngtech.archunit.library.cycle_detection.rules.CycleArchCondition;
import com.tngtech.archunit.library.modules.AnnotationDescriptor;
import com.tngtech.archunit.library.modules.ArchModule;
import com.tngtech.archunit.library.modules.ModuleDependency;
import com.tngtech.archunit.library.modules.syntax.AllowedModuleDependencies;
import com.tngtech.archunit.library.modules.syntax.ModuleDependencyScope;
import com.tngtech.archunit.library.modules.syntax.ModulesByAnnotationRule;
import com.tngtech.archunit.library.modules.syntax.ModulesByAnnotationShould;
import com.tngtech.archunit.library.modules.syntax.ModulesRule;
import com.tngtech.archunit.library.modules.syntax.ModulesShould;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

class ModulesShouldInternal<DESCRIPTOR extends ArchModule.Descriptor>
implements ModulesShould<DESCRIPTOR> {
    final Function<ArchCondition<ArchModule<DESCRIPTOR>>, ArchRule> createRule;

    ModulesShouldInternal(Function<ArchCondition<ArchModule<DESCRIPTOR>>, ArchRule> createRule) {
        this.createRule = createRule;
    }

    @Override
    public ModulesRule<DESCRIPTOR> respectTheirAllowedDependencies(DescribedPredicate<? super ModuleDependency<DESCRIPTOR>> allowedDependencyPredicate, ModuleDependencyScope dependencyScope) {
        return new ModulesRuleInternal<DESCRIPTOR>(this.createRule, relevantClassDependencyPredicate -> new RespectTheirAllowedDependenciesCondition(allowedDependencyPredicate.forSubtype(), dependencyScope, (Predicate<Dependency>)relevantClassDependencyPredicate));
    }

    @Override
    public ModulesRule<DESCRIPTOR> respectTheirAllowedDependencies(AllowedModuleDependencies allowedDependencies, ModuleDependencyScope dependencyScope) {
        return this.respectTheirAllowedDependencies(allowedDependencies.asPredicate(), dependencyScope);
    }

    @Override
    public ModulesRule<DESCRIPTOR> onlyDependOnEachOtherThroughClassesThat(DescribedPredicate<? super JavaClass> predicate) {
        return new ModulesRuleInternal<DESCRIPTOR>(this.createRule, relevantClassDependencyPredicate -> new ArchCondition<ArchModule<DESCRIPTOR>>("only depend on each other through classes that " + predicate.getDescription(), new Object[0], (Predicate)relevantClassDependencyPredicate, predicate){
            final /* synthetic */ Predicate val$relevantClassDependencyPredicate;
            final /* synthetic */ DescribedPredicate val$predicate;
            {
                this.val$relevantClassDependencyPredicate = predicate;
                this.val$predicate = describedPredicate;
                super(description, args);
            }

            @Override
            public void check(ArchModule<DESCRIPTOR> module, ConditionEvents events) {
                module.getModuleDependenciesFromSelf().stream().flatMap(moduleDependency -> moduleDependency.toClassDependencies().stream()).filter(this.val$relevantClassDependencyPredicate).filter(classDependency -> !this.val$predicate.test(classDependency.getTargetClass())).forEach(classDependency -> events.add(SimpleConditionEvent.violated(classDependency, classDependency.getDescription())));
            }
        });
    }

    @Override
    public ClassesThat<ModulesRule<DESCRIPTOR>> onlyDependOnEachOtherThroughClassesThat() {
        return new ClassesThatInternal<ModulesRule<DESCRIPTOR>>(this::onlyDependOnEachOtherThroughClassesThat);
    }

    @Override
    public ModulesRule<DESCRIPTOR> beFreeOfCycles() {
        return new ModulesRuleInternal<DESCRIPTOR>(this.createRule, relevantClassDependencyPredicate -> CycleArchCondition.builder().retrieveClassesBy(Function.identity()).retrieveDescriptionBy(ArchModule::getName).retrieveOutgoingDependenciesBy(ArchModule::getClassDependenciesFromSelf).onlyConsiderDependencies((Predicate<Dependency>)relevantClassDependencyPredicate).build());
    }

    private static class ModulesRuleInternal<DESCRIPTOR extends ArchModule.Descriptor>
    implements ModulesRule<DESCRIPTOR> {
        private final Function<ArchCondition<ArchModule<DESCRIPTOR>>, ArchRule> createRule;
        private final Function<ArchRule, ArchRule> modifyRule;
        private final Function<Predicate<Dependency>, ArchCondition<ArchModule<DESCRIPTOR>>> createCondition;
        private final Predicate<Dependency> relevantClassDependencyPredicate;

        ModulesRuleInternal(Function<ArchCondition<ArchModule<DESCRIPTOR>>, ArchRule> createRule, Function<Predicate<Dependency>, ArchCondition<ArchModule<DESCRIPTOR>>> createCondition) {
            this(createRule, createCondition, x -> x, __ -> true);
        }

        private ModulesRuleInternal(Function<ArchCondition<ArchModule<DESCRIPTOR>>, ArchRule> createRule, Function<Predicate<Dependency>, ArchCondition<ArchModule<DESCRIPTOR>>> createCondition, Function<ArchRule, ArchRule> modifyRule, Predicate<Dependency> relevantClassDependencyPredicate) {
            this.createRule = createRule;
            this.createCondition = createCondition;
            this.modifyRule = modifyRule;
            this.relevantClassDependencyPredicate = relevantClassDependencyPredicate;
        }

        @Override
        public String getDescription() {
            return this.createRule().getDescription();
        }

        @Override
        public void check(JavaClasses classes) {
            this.createRule().check(classes);
        }

        @Override
        public EvaluationResult evaluate(JavaClasses classes) {
            return this.createRule().evaluate(classes);
        }

        @Override
        public ModulesShould<DESCRIPTOR> andShould() {
            return new ModulesShouldInternal(this::andShould);
        }

        @Override
        public ArchRule andShould(ArchCondition<? super ArchModule<DESCRIPTOR>> condition) {
            return this.createRule(this.createCondition().and(condition.as("should " + condition.getDescription(), new Object[0])));
        }

        @Override
        public ModulesRule<DESCRIPTOR> as(String newDescription) {
            return new ModulesRuleInternal<DESCRIPTOR>(this.createRule, this.createCondition, rule -> (ArchRule)this.modifyRule.apply((ArchRule)rule).as(newDescription), this.relevantClassDependencyPredicate);
        }

        @Override
        public ModulesRule<DESCRIPTOR> because(String reason) {
            return new ModulesRuleInternal<DESCRIPTOR>(this.createRule, this.createCondition, rule -> this.modifyRule.apply((ArchRule)rule).because(reason), this.relevantClassDependencyPredicate);
        }

        @Override
        public ModulesRule<DESCRIPTOR> allowEmptyShould(boolean allowEmptyShould) {
            return new ModulesRuleInternal<DESCRIPTOR>(this.createRule, this.createCondition, rule -> this.modifyRule.apply((ArchRule)rule).allowEmptyShould(allowEmptyShould), this.relevantClassDependencyPredicate);
        }

        @Override
        public ModulesRule<DESCRIPTOR> ignoreDependency(Class<?> origin, Class<?> target) {
            return this.ignoreDependency(Dependency.Predicates.dependency(origin, target));
        }

        @Override
        public ModulesRule<DESCRIPTOR> ignoreDependency(String originFullyQualifiedClassName, String targetFullyQualifiedClassName) {
            return this.ignoreDependency(Dependency.Predicates.dependency(originFullyQualifiedClassName, targetFullyQualifiedClassName));
        }

        @Override
        public ModulesRule<DESCRIPTOR> ignoreDependency(Predicate<? super JavaClass> originPredicate, Predicate<? super JavaClass> targetPredicate) {
            return this.ignoreDependency(dependency -> originPredicate.test(dependency.getOriginClass()) && targetPredicate.test(dependency.getTargetClass()));
        }

        @Override
        public ModulesRule<DESCRIPTOR> ignoreDependency(Predicate<? super Dependency> dependencyPredicate) {
            return new ModulesRuleInternal<DESCRIPTOR>(this.createRule, this.createCondition, this.modifyRule, dependency -> this.relevantClassDependencyPredicate.test((Dependency)dependency) && !dependencyPredicate.test((Dependency)dependency));
        }

        private ArchRule createRule() {
            return this.createRule(this.createCondition());
        }

        private ArchCondition<ArchModule<DESCRIPTOR>> createCondition() {
            return this.createCondition.apply(this.relevantClassDependencyPredicate);
        }

        private ArchRule createRule(ArchCondition<ArchModule<DESCRIPTOR>> condition) {
            return this.modifyRule.apply(this.createRule.apply(condition));
        }
    }

    private static class RespectTheirAllowedDependenciesCondition<DESCRIPTOR extends ArchModule.Descriptor>
    extends ArchCondition<ArchModule<DESCRIPTOR>> {
        private final DescribedPredicate<ModuleDependency<DESCRIPTOR>> allowedModuleDependencyPredicate;
        private final ModuleDependencyScope dependencyScope;
        private final Predicate<Dependency> relevantClassDependencyPredicate;
        private Collection<ArchModule<DESCRIPTOR>> allModules;

        RespectTheirAllowedDependenciesCondition(DescribedPredicate<ModuleDependency<DESCRIPTOR>> allowedModuleDependencyPredicate, ModuleDependencyScope dependencyScope, Predicate<Dependency> relevantClassDependencyPredicate) {
            super("respect their allowed dependencies %s %s", allowedModuleDependencyPredicate.getDescription(), dependencyScope.getDescription());
            this.allowedModuleDependencyPredicate = allowedModuleDependencyPredicate;
            this.dependencyScope = dependencyScope;
            this.relevantClassDependencyPredicate = relevantClassDependencyPredicate;
        }

        @Override
        public void init(Collection<ArchModule<DESCRIPTOR>> allModules) {
            this.allModules = allModules;
        }

        @Override
        public void check(ArchModule<DESCRIPTOR> module, ConditionEvents events) {
            Set<ModuleDependency<DESCRIPTOR>> actualDependencies = module.getModuleDependenciesFromSelf();
            actualDependencies.stream().filter(it -> !this.allowedModuleDependencyPredicate.test((ModuleDependency<DESCRIPTOR>)it)).filter(it -> it.toClassDependencies().stream().anyMatch(this.relevantClassDependencyPredicate)).forEach(it -> events.add(SimpleConditionEvent.violated(it, it.getDescription())));
            module.getUndefinedDependencies().stream().filter(this.dependencyScope.asPredicate(this.allModules)).filter(this.relevantClassDependencyPredicate).forEach(it -> events.add(SimpleConditionEvent.violated(it, "Dependency not contained in any module: " + it.getDescription())));
        }
    }

    static class ModulesByAnnotationShouldInternal<ANNOTATION extends Annotation>
    extends ModulesShouldInternal<AnnotationDescriptor<ANNOTATION>>
    implements ModulesByAnnotationShould<ANNOTATION> {
        ModulesByAnnotationShouldInternal(Function<ArchCondition<ArchModule<AnnotationDescriptor<ANNOTATION>>>, ArchRule> createRule) {
            super(createRule);
        }

        @Override
        public ModulesByAnnotationRule<ANNOTATION> respectTheirAllowedDependenciesDeclaredIn(String annotationPropertyName, ModuleDependencyScope dependencyScope) {
            return new ModulesByAnnotationRuleInternal(this.respectTheirAllowedDependencies(DescribedPredicate.describe("declared in '" + annotationPropertyName + "'", moduleDependency -> {
                Set<String> allowedDependencies = this.getAllowedDependencies((Annotation)((AnnotationDescriptor)moduleDependency.getOrigin().getDescriptor()).getAnnotation(), annotationPropertyName);
                return allowedDependencies.contains(moduleDependency.getTarget().getName());
            }), dependencyScope));
        }

        @Override
        public ModulesByAnnotationRule<ANNOTATION> onlyDependOnEachOtherThroughPackagesDeclaredIn(final String annotationPropertyName) {
            return new ModulesByAnnotationRuleInternal(new ModulesRuleInternal(this.createRule, relevantClassDependencyPredicate -> new ArchCondition<ArchModule<AnnotationDescriptor<ANNOTATION>>>(String.format("only depend on each other through packages declared in '%s'", annotationPropertyName), new Object[0], (Predicate)relevantClassDependencyPredicate){
                final /* synthetic */ Predicate val$relevantClassDependencyPredicate;
                {
                    this.val$relevantClassDependencyPredicate = predicate;
                    super(description, args);
                }

                @Override
                public void check(ArchModule<AnnotationDescriptor<ANNOTATION>> module, ConditionEvents events) {
                    module.getModuleDependenciesFromSelf().forEach(moduleDependency -> {
                        Object descriptor = ((AnnotationDescriptor)moduleDependency.getTarget().getDescriptor()).getAnnotation();
                        String[] apiPackageIdentifiers = this.getStringArrayAnnotationProperty(descriptor, annotationPropertyName);
                        DescribedPredicate<JavaClass> predicate = JavaClass.Predicates.resideInAnyPackage(apiPackageIdentifiers);
                        moduleDependency.toClassDependencies().stream().filter(this.val$relevantClassDependencyPredicate).filter(classDependency -> !predicate.test(classDependency.getTargetClass())).forEach(classDependency -> events.add(SimpleConditionEvent.violated(classDependency, classDependency.getDescription())));
                    });
                }
            }));
        }

        private Set<String> getAllowedDependencies(Annotation annotation, String annotationPropertyName) {
            String[] allowedDependencies = this.getStringArrayAnnotationProperty(annotation, annotationPropertyName);
            return ImmutableSet.copyOf(allowedDependencies);
        }

        private String[] getStringArrayAnnotationProperty(Annotation annotation, String annotationPropertyName) {
            Object value = ModulesByAnnotationShouldInternal.getAnnotationProperty(annotation, annotationPropertyName);
            try {
                return (String[])value;
            }
            catch (ClassCastException e) {
                String message = String.format("Property @%s.%s() must be of type String[]", annotation.annotationType().getSimpleName(), annotationPropertyName);
                throw new IllegalArgumentException(message, e);
            }
        }

        private static Object getAnnotationProperty(Annotation annotation, String annotationPropertyName) {
            try {
                return annotation.annotationType().getMethod(annotationPropertyName, new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String message = String.format("Could not invoke @%s.%s()", annotation.annotationType().getSimpleName(), annotationPropertyName);
                throw new IllegalArgumentException(message, e);
            }
        }

        private static class ModulesByAnnotationRuleInternal<ANNOTATION extends Annotation>
        implements ModulesByAnnotationRule<ANNOTATION> {
            private final ModulesRule<AnnotationDescriptor<ANNOTATION>> delegate;

            ModulesByAnnotationRuleInternal(ModulesRule<AnnotationDescriptor<ANNOTATION>> delegate) {
                this.delegate = delegate;
            }

            @Override
            public ModulesByAnnotationShouldInternal<ANNOTATION> andShould() {
                return new ModulesByAnnotationShouldInternal(this::andShould);
            }

            @Override
            public ArchRule andShould(ArchCondition<? super ArchModule<AnnotationDescriptor<ANNOTATION>>> condition) {
                return this.delegate.andShould(condition);
            }

            @Override
            public String getDescription() {
                return this.delegate.getDescription();
            }

            @Override
            public void check(JavaClasses classes) {
                this.delegate.check(classes);
            }

            @Override
            public EvaluationResult evaluate(JavaClasses classes) {
                return this.delegate.evaluate(classes);
            }

            @Override
            public ModulesByAnnotationRule<ANNOTATION> as(String newDescription) {
                return new ModulesByAnnotationRuleInternal<ANNOTATION>(this.delegate.as(newDescription));
            }

            @Override
            public ModulesByAnnotationRule<ANNOTATION> because(String reason) {
                return new ModulesByAnnotationRuleInternal<ANNOTATION>(this.delegate.because(reason));
            }

            @Override
            public ModulesByAnnotationRule<ANNOTATION> allowEmptyShould(boolean allowEmptyShould) {
                return new ModulesByAnnotationRuleInternal<ANNOTATION>(this.delegate.allowEmptyShould(allowEmptyShould));
            }

            @Override
            public ModulesByAnnotationRule<ANNOTATION> ignoreDependency(Class<?> origin, Class<?> target) {
                return new ModulesByAnnotationRuleInternal<ANNOTATION>(this.delegate.ignoreDependency(origin, target));
            }

            @Override
            public ModulesByAnnotationRule<ANNOTATION> ignoreDependency(String originFullyQualifiedClassName, String targetFullyQualifiedClassName) {
                return new ModulesByAnnotationRuleInternal<ANNOTATION>(this.delegate.ignoreDependency(originFullyQualifiedClassName, targetFullyQualifiedClassName));
            }

            @Override
            public ModulesByAnnotationRule<ANNOTATION> ignoreDependency(Predicate<? super JavaClass> originPredicate, Predicate<? super JavaClass> targetPredicate) {
                return new ModulesByAnnotationRuleInternal<ANNOTATION>(this.delegate.ignoreDependency(originPredicate, targetPredicate));
            }

            @Override
            public ModulesByAnnotationRule<ANNOTATION> ignoreDependency(Predicate<? super Dependency> dependencyPredicate) {
                return new ModulesByAnnotationRuleInternal<ANNOTATION>(this.delegate.ignoreDependency(dependencyPredicate));
            }
        }
    }
}

