/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class ExpressionListDeParser<T extends Expression>
extends AbstractDeParser<ExpressionList<?>> {
    private final ExpressionVisitor<StringBuilder> expressionVisitor;

    public ExpressionListDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder builder) {
        super(builder);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(ExpressionList<?> expressionList) {
        List<String> names;
        String comma = expressionList instanceof NamedExpressionList ? " " : ", ";
        List<String> list = names = expressionList instanceof NamedExpressionList ? ((NamedExpressionList)expressionList).getNames() : Collections.nCopies(expressionList.size(), "");
        if (expressionList instanceof ParenthesedExpressionList) {
            this.builder.append("(");
        }
        int i = 0;
        for (Expression expression : expressionList) {
            String name;
            if (i > 0) {
                this.builder.append(comma);
            }
            if (!(name = names.get(i)).isEmpty()) {
                this.builder.append(name);
                this.builder.append(" ");
            }
            expression.accept(this.expressionVisitor, null);
            ++i;
        }
        if (expressionList instanceof ParenthesedExpressionList) {
            this.builder.append(")");
        }
    }
}

