/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import javax.measure.UnitConverter;
import tec.uom.lib.common.function.ValueSupplier;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.PowersOfIntConverter;

public final class RationalConverter
extends AbstractConverter
implements ValueSupplier<Double>,
Supplier<Double>,
DoubleSupplier {
    private static final long serialVersionUID = 3563384008357680074L;
    private final BigInteger dividend;
    private final BigInteger divisor;

    public RationalConverter(BigInteger dividend, BigInteger divisor) {
        if (divisor.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("Negative or zero divisor");
        }
        this.dividend = dividend;
        this.divisor = divisor;
    }

    public RationalConverter(long dividend, long divisor) {
        this(BigInteger.valueOf(dividend), BigInteger.valueOf(divisor));
    }

    public static RationalConverter of(BigInteger dividend, BigInteger divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public static RationalConverter of(long dividend, long divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public static RationalConverter of(double dividend, double divisor) {
        return new RationalConverter(BigDecimal.valueOf(dividend).toBigInteger(), BigDecimal.valueOf(divisor).toBigInteger());
    }

    public BigInteger getDividend() {
        return this.dividend;
    }

    public BigInteger getDivisor() {
        return this.divisor;
    }

    @Override
    public double convertWhenNotIdentity(double value) {
        return value * RationalConverter.toDouble(this.dividend) / RationalConverter.toDouble(this.divisor);
    }

    private static double toDouble(BigInteger integer) {
        return integer.bitLength() < 64 ? (double)integer.longValue() : integer.doubleValue();
    }

    @Override
    protected Number convertWhenNotIdentity(BigInteger value, MathContext ctx) {
        BigInteger newDividend = this.dividend.multiply(value);
        BigInteger[] divideAndRemainder = newDividend.divideAndRemainder(this.divisor);
        BigInteger divisionResult = divideAndRemainder[0];
        BigInteger divisionRemainder = divideAndRemainder[1];
        if (BigInteger.ZERO.compareTo(divisionRemainder) == 0) {
            return divisionResult;
        }
        return this.convertWhenNotIdentity(new BigDecimal(value), ctx);
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        BigDecimal decimalDividend = new BigDecimal(this.dividend, 0);
        BigDecimal decimalDivisor = new BigDecimal(this.divisor, 0);
        return value.multiply(decimalDividend, ctx).divide(decimalDivisor, ctx);
    }

    public boolean isIdentity() {
        return this.dividend.equals(this.divisor);
    }

    @Override
    protected boolean isSimpleCompositionWith(AbstractConverter that) {
        if (that instanceof RationalConverter) {
            return true;
        }
        return that instanceof PowersOfIntConverter;
    }

    @Override
    protected AbstractConverter simpleCompose(AbstractConverter that) {
        if (that instanceof RationalConverter) {
            return this.composeSameType((RationalConverter)that);
        }
        if (that instanceof PowersOfIntConverter) {
            return this.composeSameType(((PowersOfIntConverter)that).toRationalConverter());
        }
        throw new IllegalStateException(String.format("%s.simpleCompose() not handled for converter %s", this, that));
    }

    @Override
    public RationalConverter inverseWhenNotIdentity() {
        return this.dividend.signum() == -1 ? new RationalConverter(this.getDivisor().negate(), this.getDividend().negate()) : new RationalConverter(this.getDivisor(), this.getDividend());
    }

    @Override
    public final String transformationLiteral() {
        return String.format("x -> x * (%s)/(%s)", this.dividend, this.divisor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RationalConverter) {
            RationalConverter that = (RationalConverter)obj;
            return Objects.equals(this.dividend, that.dividend) && Objects.equals(this.divisor, that.divisor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dividend, this.divisor);
    }

    public boolean isLinear() {
        return true;
    }

    public Double getValue() {
        return this.getAsDouble();
    }

    @Override
    public double getAsDouble() {
        return RationalConverter.toDouble(this.dividend) / RationalConverter.toDouble(this.divisor);
    }

    @Override
    public Double get() {
        return this.getValue();
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof RationalConverter) {
            return this.getValue().compareTo(((RationalConverter)o).getValue());
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    private AbstractConverter composeSameType(RationalConverter that) {
        BigInteger newDividend = this.getDividend().multiply(that.getDividend());
        BigInteger newDivisor = this.getDivisor().multiply(that.getDivisor());
        BigInteger gcd = newDividend.gcd(newDivisor);
        newDividend = newDividend.divide(gcd);
        newDivisor = newDivisor.divide(gcd);
        return newDividend.equals(BigInteger.ONE) && newDivisor.equals(BigInteger.ONE) ? IDENTITY : new RationalConverter(newDividend, newDivisor);
    }
}

